/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.supports.protocol.codec.BinaryDecoder;
import org.jetlinks.supports.protocol.codec.defaults.MapDecoderBuilder;

public class MapBinaryDecoder<K, V>
implements BinaryDecoder<Map<K, V>>,
MapDecoderBuilder<K, V> {
    private final List<Decoder<K, V>> decoders = new ArrayList<Decoder<K, V>>();

    @Override
    public Map<K, V> decode(byte[] payload, int offset) {
        LinkedHashMap map = new LinkedHashMap();
        for (Decoder<K, V> decoder : this.decoders) {
            map.put(((Decoder)decoder).keyDecoder.decode(payload, offset), ((Decoder)decoder).valueDecoder.decode(payload, offset));
        }
        return map;
    }

    @Override
    public MapDecoderBuilder<K, V> add(BinaryDecoder<? extends K> keyDecoder, BinaryDecoder<? extends V> valueDecoder) {
        this.decoders.add(new Decoder<K, V>(keyDecoder, valueDecoder));
        return this;
    }

    @Override
    public BinaryDecoder<Map<K, V>> build() {
        return this;
    }

    private static class Decoder<K, V> {
        private final BinaryDecoder<? extends K> keyDecoder;
        private final BinaryDecoder<? extends V> valueDecoder;

        @ConstructorProperties(value={"keyDecoder", "valueDecoder"})
        public Decoder(BinaryDecoder<? extends K> keyDecoder, BinaryDecoder<? extends V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }
}

