/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.management.jar;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import org.jetlinks.supports.protocol.management.jar.ProtocolClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JarProtocolSupportLoader
implements ProtocolSupportLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JarProtocolSupportLoader.class);
    private ServiceContext serviceContext;
    private final Map<String, ProtocolClassLoader> protocolLoaders = new ConcurrentHashMap<String, ProtocolClassLoader>();
    private final Map<String, ProtocolSupportProvider> loaded = new ConcurrentHashMap<String, ProtocolSupportProvider>();

    @Override
    public String getProvider() {
        return "jar";
    }

    protected ProtocolClassLoader createClassLoader(URL location) {
        return new ProtocolClassLoader(new URL[]{location}, this.getClass().getClassLoader());
    }

    protected void closeAll() {
        this.protocolLoaders.values().forEach(this::closeLoader);
        this.protocolLoaders.clear();
        this.loaded.clear();
    }

    protected void closeLoader(ProtocolClassLoader loader) {
        loader.close();
    }

    @Override
    public Mono<? extends ProtocolSupport> load(ProtocolSupportDefinition definition) {
        return Mono.defer(() -> {
            try {
                Map<String, Object> config = definition.getConfiguration();
                String location = Optional.ofNullable(config.get("location")).map(String::valueOf).orElseThrow(() -> new IllegalArgumentException("location"));
                String provider = Optional.ofNullable(config.get("provider")).map(String::valueOf).map(String::trim).orElse(null);
                URL url = !location.contains("://") ? new File(location).toURI().toURL() : new URL("jar:" + location + "!/");
                URL fLocation = url;
                ProtocolClassLoader loader = this.protocolLoaders.compute(definition.getId(), (key, old) -> {
                    if (null != old) {
                        try {
                            this.closeLoader((ProtocolClassLoader)old);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return this.createClassLoader(fLocation);
                });
                log.debug("load protocol support from : {}", (Object)location);
                ProtocolSupportProvider supportProvider = provider != null ? (ProtocolSupportProvider)Class.forName(provider, true, loader).newInstance() : ServiceLoader.load(ProtocolSupportProvider.class, loader).iterator().next();
                ProtocolSupportProvider oldProvider = this.loaded.put(provider, supportProvider);
                try {
                    if (null != oldProvider) {
                        oldProvider.dispose();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return supportProvider.create(this.serviceContext);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).subscribeOn(Schedulers.elastic());
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

