/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetlinks.core.cluster.ClusterCache;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisClusterCache<K, V>
implements ClusterCache<K, V> {
    private final ReactiveHashOperations<Object, K, V> hash;
    private ReactiveRedisOperations<Object, Object> redis;
    private final String redisKey;

    public RedisClusterCache(String redisKey, ReactiveRedisOperations<Object, Object> redis) {
        this(redisKey, redis.opsForHash());
        this.redis = redis;
    }

    private RedisClusterCache(String redisKey, ReactiveHashOperations<Object, K, V> hash) {
        this.hash = hash;
        this.redisKey = redisKey;
    }

    public Mono<V> get(K key) {
        return this.hash.get((Object)this.redisKey, key);
    }

    public Flux<Map.Entry<K, V>> get(Collection<K> key) {
        return this.hash.multiGet((Object)this.redisKey, key).flatMapIterable(list -> {
            Object[] keyArr = key.toArray();
            ArrayList<RedisSimpleEntry> entries = new ArrayList<RedisSimpleEntry>(keyArr.length);
            for (int i = 0; i < list.size(); ++i) {
                entries.add(new RedisSimpleEntry(keyArr[i], list.get(i)));
            }
            return entries;
        });
    }

    public Mono<Boolean> put(K key, V value) {
        return this.hash.put((Object)this.redisKey, key, value);
    }

    public Mono<Boolean> putIfAbsent(K key, V value) {
        return this.hash.putIfAbsent((Object)this.redisKey, key, value);
    }

    public Mono<V> getAndRemove(K key) {
        return this.hash.get((Object)this.redisKey, key).flatMap(v -> this.remove(key).thenReturn(v));
    }

    public Mono<Boolean> remove(K key) {
        return this.hash.remove((Object)this.redisKey, new Object[]{key}).thenReturn((Object)true);
    }

    public Mono<Boolean> remove(Collection<K> key) {
        return this.hash.remove((Object)this.redisKey, key.toArray()).thenReturn((Object)true);
    }

    public Mono<Boolean> containsKey(K key) {
        return this.hash.hasKey((Object)this.redisKey, key);
    }

    public Flux<K> keys() {
        return this.hash.keys((Object)this.redisKey);
    }

    public Flux<V> values() {
        return this.hash.values((Object)this.redisKey);
    }

    public Mono<Boolean> putAll(Map<? extends K, ? extends V> multi) {
        if (CollectionUtils.isEmpty(multi)) {
            return Mono.just((Object)true);
        }
        return this.hash.putAll((Object)this.redisKey, multi);
    }

    public Mono<Integer> size() {
        return this.hash.size((Object)this.redisKey).map(Number::intValue);
    }

    public Flux<Map.Entry<K, V>> entries() {
        return this.hash.scan((Object)this.redisKey).map(x$0 -> new RedisHashEntry(x$0));
    }

    public Mono<Void> clear() {
        return this.hash.delete((Object)this.redisKey).then();
    }

    class RedisHashEntry
    implements Map.Entry<K, V> {
        Map.Entry<K, V> entry;
        V value;

        RedisHashEntry(Map.Entry<K, V> entry) {
            this.entry = entry;
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object old = this.getValue();
            this.value = value;
            RedisClusterCache.this.put(this.getKey(), this.value).subscribe();
            return old;
        }
    }

    class RedisSimpleEntry
    implements Map.Entry<K, V> {
        K key;
        V value;

        RedisSimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object old = this.getValue();
            if (value == null) {
                RedisClusterCache.this.remove(this.getKey()).subscribe();
            } else {
                this.value = value;
                RedisClusterCache.this.put(this.getKey(), this.value).subscribe();
            }
            return old;
        }
    }
}

