/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.config;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.config.ConfigStorage;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ClusterConfigStorage
implements ConfigStorage {
    ClusterCache<String, Object> cache;

    public ClusterCache<String, Object> getCache() {
        return this.cache;
    }

    public Mono<Value> getConfig(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return Mono.empty();
        }
        return this.cache.get((Object)key).map(Value::simple);
    }

    public Mono<Values> getConfigs(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Mono.empty();
        }
        return this.cache.get(keys).collectList().map(list -> list.stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (_1, _2) -> _2))).map(Values::of);
    }

    public Mono<Boolean> setConfigs(Map<String, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Mono.just((Object)true);
        }
        return this.cache.putAll(values);
    }

    public Mono<Boolean> setConfig(String key, Object value) {
        if (value == null || key == null) {
            return Mono.just((Object)true);
        }
        return this.cache.put((Object)key, value);
    }

    public Mono<Value> getAndRemove(String key) {
        return this.cache.getAndRemove((Object)key).map(Value::simple);
    }

    public Mono<Boolean> remove(String key) {
        return this.cache.remove((Object)key);
    }

    public Mono<Boolean> remove(Collection<String> key) {
        return this.cache.remove(key);
    }

    public Mono<Boolean> clear() {
        return this.cache.clear().thenReturn((Object)true);
    }

    @ConstructorProperties(value={"cache"})
    public ClusterConfigStorage(ClusterCache<String, Object> cache) {
        this.cache = cache;
    }
}

