/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONObject;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.DerivedMetadataMessage;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DeviceRegisterMessage;
import org.jetlinks.core.message.DeviceUnRegisterMessage;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessage;
import org.jetlinks.core.message.firmware.ReadFirmwareMessageReply;
import org.jetlinks.core.message.firmware.ReportFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessage;
import org.jetlinks.core.message.firmware.RequestFirmwareMessageReply;
import org.jetlinks.core.message.firmware.UpgradeFirmwareMessage;
import org.jetlinks.core.message.firmware.UpgradeFirmwareProgressMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessageReply;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.supports.utils.MqttTopicUtils;
import org.springframework.util.Assert;

@Deprecated
class JetlinksTopicMessageCodec {
    JetlinksTopicMessageCodec() {
    }

    protected EncodedTopic encode(String deviceId, Message message) {
        Assert.hasText((String)deviceId, (String)"deviceId can not be null");
        Assert.notNull((Object)message, (String)"message can not be null");
        if (message instanceof ReadPropertyMessage) {
            String topic = "/".concat(deviceId).concat("/properties/read");
            JSONObject mqttData = new JSONObject();
            mqttData.put("messageId", (Object)message.getMessageId());
            mqttData.put("properties", (Object)((ReadPropertyMessage)message).getProperties());
            mqttData.put("deviceId", (Object)deviceId);
            return new EncodedTopic(topic, mqttData);
        }
        if (message instanceof WritePropertyMessage) {
            String topic = "/".concat(deviceId).concat("/properties/write");
            JSONObject mqttData = new JSONObject();
            mqttData.put("messageId", (Object)message.getMessageId());
            mqttData.put("properties", (Object)((WritePropertyMessage)message).getProperties());
            mqttData.put("deviceId", (Object)deviceId);
            return new EncodedTopic(topic, mqttData);
        }
        if (message instanceof FunctionInvokeMessage) {
            String topic = "/".concat(deviceId).concat("/function/invoke");
            FunctionInvokeMessage invokeMessage = (FunctionInvokeMessage)message;
            JSONObject mqttData = new JSONObject();
            mqttData.put("messageId", (Object)message.getMessageId());
            mqttData.put("function", (Object)invokeMessage.getFunctionId());
            mqttData.put("inputs", (Object)invokeMessage.getInputs());
            mqttData.put("deviceId", (Object)deviceId);
            return new EncodedTopic(topic, mqttData);
        }
        if (message instanceof UpgradeFirmwareMessage) {
            String topic = "/".concat(deviceId).concat("/firmware/upgrade");
            UpgradeFirmwareMessage firmwareMessage = (UpgradeFirmwareMessage)message;
            JSONObject mqttData = new JSONObject();
            mqttData.put("messageId", (Object)message.getMessageId());
            mqttData.put("url", (Object)firmwareMessage.getUrl());
            mqttData.put("sign", (Object)firmwareMessage.getSign());
            mqttData.put("version", (Object)firmwareMessage.getVersion());
            mqttData.put("signMethod", (Object)firmwareMessage.getSignMethod());
            mqttData.put("parameters", (Object)firmwareMessage.getParameters());
            mqttData.put("deviceId", (Object)deviceId);
            return new EncodedTopic(topic, mqttData);
        }
        if (message instanceof ReadFirmwareMessage) {
            String topic = "/".concat(deviceId).concat("/firmware/read");
            JSONObject mqttData = new JSONObject();
            mqttData.put("messageId", (Object)message.getMessageId());
            mqttData.put("deviceId", (Object)deviceId);
            return new EncodedTopic(topic, mqttData);
        }
        if (message instanceof RequestFirmwareMessageReply) {
            String topic = "/".concat(deviceId).concat("/firmware/pull/reply");
            RequestFirmwareMessageReply firmwareMessage = (RequestFirmwareMessageReply)message;
            JSONObject mqttData = new JSONObject();
            mqttData.put("messageId", (Object)message.getMessageId());
            mqttData.put("url", (Object)firmwareMessage.getUrl());
            mqttData.put("sign", (Object)firmwareMessage.getSign());
            mqttData.put("version", (Object)firmwareMessage.getVersion());
            mqttData.put("signMethod", (Object)firmwareMessage.getSignMethod());
            mqttData.put("parameters", (Object)firmwareMessage.getParameters());
            mqttData.put("deviceId", (Object)deviceId);
            return new EncodedTopic(topic, mqttData);
        }
        if (message instanceof ChildDeviceMessage) {
            ChildDeviceMessage childDeviceMessage = (ChildDeviceMessage)message;
            EncodedTopic result = this.encode(childDeviceMessage.getChildDeviceId(), childDeviceMessage.getChildDeviceMessage());
            String topic = "/".concat(deviceId).concat("/child").concat(result.topic);
            result.payload.put("deviceId", (Object)childDeviceMessage.getChildDeviceId());
            return new EncodedTopic(topic, result.payload);
        }
        return null;
    }

    protected DecodeResult decode(String topic, JSONObject object) {
        DecodeResult result = new DecodeResult(topic);
        Message message = null;
        if (result.isEvent()) {
            message = this.decodeEvent(result, object);
        } else if (result.isReportProperties()) {
            message = this.decodeReportPropertyReply(result, object);
        } else if (result.isReadPropertyReply()) {
            message = this.decodeReadPropertyReply(result, object);
        } else if (result.isWritePropertyReply()) {
            message = this.decodeWritePropertyReply(result, object);
        } else if (result.isFunctionInvokeReply()) {
            message = this.decodeInvokeReply(result, object);
        } else if (result.isRegister()) {
            message = this.decodeRegister(result, object);
        } else if (result.isUnregister()) {
            message = this.decodeUnregister(result, object);
        } else if (result.isDerivedMetadata()) {
            message = this.decodeDerivedMetadata(result, object);
        } else if (result.isReadFirmwareReply()) {
            message = (Message)object.toJavaObject(ReadFirmwareMessageReply.class);
        } else if (result.isRequestFirmware()) {
            message = (Message)object.toJavaObject(RequestFirmwareMessage.class);
        } else if (result.isReportFirmware()) {
            message = (Message)object.toJavaObject(ReportFirmwareMessage.class);
        } else if (result.isUpgradeFirmwareProgress()) {
            message = (Message)object.toJavaObject(UpgradeFirmwareProgressMessage.class);
        }
        if (result.isChild()) {
            if (topic.endsWith("connected")) {
                message = (Message)object.toJavaObject(DeviceOnlineMessage.class);
            } else if (topic.endsWith("disconnect")) {
                message = (Message)object.toJavaObject(DeviceOfflineMessage.class);
            }
            if (message == null) {
                throw new UnsupportedOperationException("unsupported topic:" + topic);
            }
            this.applyCommons(message, result, object);
            ChildDeviceMessageReply children = new ChildDeviceMessageReply();
            children.setChildDeviceId(result.getChildDeviceId());
            children.setDeviceId(result.getDeviceId());
            children.setChildDeviceMessage(message);
            children.setSuccess(Optional.ofNullable(object.getBoolean("success")).orElse(true).booleanValue());
            children.setTimestamp(Optional.ofNullable(object.getLong("timestamp")).orElse(System.currentTimeMillis()).longValue());
            Optional.ofNullable(object.getString("messageId")).ifPresent(arg_0 -> ((ChildDeviceMessageReply)children).setMessageId(arg_0));
            result.message = children;
        } else {
            if (message == null) {
                throw new UnsupportedOperationException("unsupported topic:" + topic);
            }
            this.applyCommons(message, result, object);
            result.message = message;
        }
        return result;
    }

    private Message decodeEvent(DecodeResult result, JSONObject event) {
        EventMessage message = (EventMessage)event.toJavaObject(EventMessage.class);
        message.setData(event.get((Object)"data"));
        message.setEvent((String)result.args.get("eventId"));
        return message;
    }

    private Message decodeReadPropertyReply(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(ReadPropertyMessageReply.class);
    }

    private Message decodeReportPropertyReply(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(ReportPropertyMessage.class);
    }

    private Message decodeWritePropertyReply(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(WritePropertyMessageReply.class);
    }

    private Message decodeInvokeReply(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(FunctionInvokeMessageReply.class);
    }

    private Message decodeRegister(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(DeviceRegisterMessage.class);
    }

    private Message decodeUnregister(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(DeviceUnRegisterMessage.class);
    }

    private Message decodeDerivedMetadata(DecodeResult result, JSONObject data) {
        return (Message)data.toJavaObject(DerivedMetadataMessage.class);
    }

    private void applyCommons(Message message, DecodeResult result, JSONObject data) {
        if (message instanceof CommonDeviceMessageReply) {
            CommonDeviceMessageReply reply = (CommonDeviceMessageReply)message;
            reply.setSuccess(Optional.ofNullable(data.getBoolean("success")).orElse(true).booleanValue());
            reply.setTimestamp(Optional.ofNullable(data.getLong("timestamp")).orElse(System.currentTimeMillis()).longValue());
            if (result.isChild()) {
                reply.setDeviceId(result.getChildDeviceId());
            } else {
                reply.setDeviceId(result.getDeviceId());
            }
        }
        if (message instanceof CommonDeviceMessage) {
            CommonDeviceMessage msg = (CommonDeviceMessage)message;
            msg.setTimestamp(Optional.ofNullable(data.getLong("timestamp")).orElse(System.currentTimeMillis()).longValue());
            if (result.isChild()) {
                msg.setDeviceId(result.getChildDeviceId());
            } else {
                msg.setDeviceId(result.getDeviceId());
            }
        }
    }

    protected class Decoded {
        Message message;

        protected Decoded() {
        }

        public Message getMessage() {
            return this.message;
        }

        public void setMessage(Message message) {
            this.message = message;
        }
    }

    protected class EncodedTopic {
        String topic;
        JSONObject payload;

        public String getTopic() {
            return this.topic;
        }

        public JSONObject getPayload() {
            return this.payload;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPayload(JSONObject payload) {
            this.payload = payload;
        }

        @ConstructorProperties(value={"topic", "payload"})
        public EncodedTopic(String topic, JSONObject payload) {
            this.topic = topic;
            this.payload = payload;
        }
    }

    protected class DecodeResult {
        private Map<String, String> args;
        private boolean child;
        private boolean event;
        private boolean readPropertyReply;
        private boolean writePropertyReply;
        private boolean functionInvokeReply;
        private boolean reportProperties;
        private boolean derivedMetadata;
        private boolean register;
        private boolean unregister;
        private boolean requestFirmware;
        private boolean reportFirmware;
        private boolean upgradeFirmwareProgress;
        private boolean readFirmwareReply;
        private final String topic;
        protected Message message;

        public DecodeResult(String topic) {
            this.topic = topic;
            this.args = MqttTopicUtils.getPathVariables("/{productId}/{deviceId}/**", topic);
            if (topic.contains("child")) {
                this.child = true;
                this.args.putAll(MqttTopicUtils.getPathVariables("/**/child/{childDeviceId}/**", topic));
            }
            if (topic.contains("event")) {
                this.event = true;
                this.args.putAll(MqttTopicUtils.getPathVariables("/**/event/{eventId}", topic));
            }
            this.derivedMetadata = topic.endsWith("metadata/derived");
            if (this.event || (this.reportProperties = topic.endsWith("properties/report")) || (this.unregister = topic.endsWith("unregister")) || (this.register = topic.endsWith("register")) || (this.readPropertyReply = topic.endsWith("properties/read/reply")) || (this.writePropertyReply = topic.endsWith("properties/write/reply")) || (this.functionInvokeReply = topic.endsWith("function/invoke/reply")) || (this.upgradeFirmwareProgress = topic.endsWith("firmware/upgrade/progress")) || (this.requestFirmware = topic.endsWith("firmware/pull")) || (this.reportFirmware = topic.endsWith("firmware/report")) || (this.readFirmwareReply = topic.endsWith("firmware/read/reply")) || (this.derivedMetadata = topic.endsWith("metadata/derived"))) {
                // empty if block
            }
        }

        public String getDeviceId() {
            return this.args.get("deviceId");
        }

        public String getChildDeviceId() {
            return this.args.get("childDeviceId");
        }

        public Map<String, String> getArgs() {
            return this.args;
        }

        public boolean isChild() {
            return this.child;
        }

        public boolean isEvent() {
            return this.event;
        }

        public boolean isReadPropertyReply() {
            return this.readPropertyReply;
        }

        public boolean isWritePropertyReply() {
            return this.writePropertyReply;
        }

        public boolean isFunctionInvokeReply() {
            return this.functionInvokeReply;
        }

        public boolean isReportProperties() {
            return this.reportProperties;
        }

        public boolean isDerivedMetadata() {
            return this.derivedMetadata;
        }

        public boolean isRegister() {
            return this.register;
        }

        public boolean isUnregister() {
            return this.unregister;
        }

        public boolean isRequestFirmware() {
            return this.requestFirmware;
        }

        public boolean isReportFirmware() {
            return this.reportFirmware;
        }

        public boolean isUpgradeFirmwareProgress() {
            return this.upgradeFirmwareProgress;
        }

        public boolean isReadFirmwareReply() {
            return this.readFirmwareReply;
        }

        public String getTopic() {
            return this.topic;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

