/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.utils.BytesUtils;

public class RpcResult
implements Payload {
    private static final Type[] types = Type.values();
    private final Type type;
    private final long requestId;
    private final ByteBuf body;

    public static RpcResult parse(Payload payload) {
        return new RpcResult(payload);
    }

    public static RpcResult complete(long messageId) {
        return new RpcResult(messageId, Type.COMPLETE, Payload.voidPayload);
    }

    public static RpcResult complete(long messageId, Payload payload) {
        return new RpcResult(messageId, Type.RESULT_AND_COMPLETE, payload);
    }

    public static RpcResult result(long messageId, Payload payload) {
        return new RpcResult(messageId, Type.RESULT, payload);
    }

    public static RpcResult error(long messageId, Payload payload) {
        return new RpcResult(messageId, Type.ERROR, payload);
    }

    private RpcResult(Payload source) {
        ByteBuf body = source.getBody();
        this.type = types[body.readByte()];
        byte[] msgId = new byte[8];
        body.getBytes(1, msgId);
        this.requestId = BytesUtils.beToLong((byte[])msgId);
        this.body = body.slice(9, body.capacity() - 9);
        body.resetReaderIndex();
    }

    private RpcResult(long requestId, Type type, Payload payload) {
        this.type = type;
        ByteBuf byteBuf = Unpooled.buffer((int)(payload.getBody().capacity() + 9));
        byteBuf.writeByte(this.type.ordinal());
        byteBuf.writeBytes(BytesUtils.longToBe((long)requestId));
        byteBuf.writeBytes(payload.getBody());
        this.body = byteBuf;
        this.requestId = requestId;
    }

    @Nonnull
    public ByteBuf getBody() {
        return this.body;
    }

    public Type getType() {
        return this.type;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public static enum Type {
        RESULT,
        COMPLETE,
        RESULT_AND_COMPLETE,
        ERROR;

    }
}

