/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.codec.Encoder;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.supports.cluster.AbstractLocalCache;
import reactor.core.publisher.Mono;

public class EventBusLocalCache<K, V>
extends AbstractLocalCache<K, V> {
    private final EventBus eventBus;
    private final String topicPrefix;
    private static final byte notifyData = 1;
    private static final Encoder<Byte> encoder = Codecs.lookup(Byte.TYPE);

    public EventBusLocalCache(String name, EventBus eventBus, ClusterManager clusterManager) {
        this(name, eventBus, clusterManager, CacheBuilder.newBuilder().build());
    }

    public EventBusLocalCache(String name, EventBus eventBus, ClusterManager clusterManager, Cache<K, Object> localCache) {
        this(name, eventBus, clusterManager.getCache(name), localCache);
    }

    public EventBusLocalCache(String name, EventBus eventBus, ClusterCache<K, V> clusterCache, Cache<K, Object> localCache) {
        super(clusterCache, localCache);
        this.eventBus = eventBus;
        this.topicPrefix = "/_sys/cluster_cache/" + name;
    }

    @Override
    protected Mono<Void> onUpdate(K key, V value) {
        return this.eventBus.publish(this.topicPrefix + "/update/" + key, encoder, (Object)1).then();
    }

    @Override
    protected Mono<Void> onRemove(K key) {
        return this.eventBus.publish(this.topicPrefix + "/remove/" + key, encoder, (Object)1).then();
    }

    @Override
    protected Mono<Void> onRemove(Collection<? extends K> key) {
        return this.eventBus.publish(this.topicPrefix + "/remove/*", encoder, (Object)1).then();
    }

    @Override
    protected Mono<Void> onClear() {
        return this.eventBus.publish(this.topicPrefix + "/remove/*", encoder, (Object)1).then();
    }
}

