/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.event;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;

public class RSocketAddress
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    private int port = ThreadLocalRandom.current().nextInt(10000, 30000);
    private String publicAddress = "127.0.0.1";
    private int publicPort = this.port;

    public static RSocketAddress of(String address, int port) {
        return RSocketAddress.of(port, address, port);
    }

    public static RSocketAddress of(int port) {
        return RSocketAddress.of(port, "127.0.0.1", port);
    }

    public String toString() {
        return "{publicAddress='" + this.publicAddress + '\'' + ", port=" + this.port + ", publicPort=" + this.publicPort + '}';
    }

    public int getPort() {
        return this.port;
    }

    public String getPublicAddress() {
        return this.publicAddress;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
    }

    public void setPublicPort(int publicPort) {
        this.publicPort = publicPort;
    }

    @ConstructorProperties(value={"port", "publicAddress", "publicPort"})
    private RSocketAddress(int port, String publicAddress, int publicPort) {
        this.port = port;
        this.publicAddress = publicAddress;
        this.publicPort = publicPort;
    }

    public static RSocketAddress of(int port, String publicAddress, int publicPort) {
        return new RSocketAddress(port, publicAddress, publicPort);
    }

    public RSocketAddress() {
    }
}

