/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.event;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RSocketPayload
implements Payload {
    private static final Logger log = LoggerFactory.getLogger(RSocketPayload.class);
    private final io.rsocket.Payload payload;
    private final ByteBuf data;

    public static RSocketPayload of(io.rsocket.Payload payload) {
        return RSocketPayload.of(payload, Unpooled.unreleasableBuffer((ByteBuf)payload.data()));
    }

    public Payload slice() {
        return RSocketPayload.of(this.payload, this.payload.sliceData());
    }

    @Nonnull
    public ByteBuf getBody() {
        return this.data;
    }

    public boolean release() {
        if (this.payload.refCnt() > 0) {
            return this.payload.release();
        }
        return true;
    }

    public boolean release(int dec) {
        if (this.payload.refCnt() >= dec) {
            return this.payload.release(dec);
        }
        return true;
    }

    public RSocketPayload retain() {
        this.payload.retain();
        return this;
    }

    public RSocketPayload retain(int inc) {
        this.payload.retain(inc);
        return this;
    }

    public String bodyToString() {
        return this.bodyToString(true);
    }

    public String bodyToString(boolean release) {
        try {
            String string = this.data.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
    }

    protected void finalize() throws Throwable {
        int refCnt = ReferenceCountUtil.refCnt((Object)this.payload);
        if (refCnt > 0) {
            log.debug("payload {} was not release properly, release() was not called before it's garbage-collected. refCnt={}", (Object)this.payload, (Object)refCnt);
        }
        super.finalize();
    }

    @ConstructorProperties(value={"payload", "data"})
    private RSocketPayload(io.rsocket.Payload payload, ByteBuf data) {
        this.payload = payload;
        this.data = data;
    }

    public static RSocketPayload of(io.rsocket.Payload payload, ByteBuf data) {
        return new RSocketPayload(payload, data);
    }
}

