/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.supports.official.JetLinksPropertyMetadata;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksObjectCodec
extends AbstractDataTypeCodec<ObjectType> {
    public String getTypeId() {
        return "object";
    }

    @Override
    public ObjectType decode(ObjectType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getJSONArray("properties")).map(list -> list.stream().map(JSONObject.class::cast).map(JetLinksPropertyMetadata::new).collect(Collectors.toList())).ifPresent(arg_0 -> ((ObjectType)type).setProperties(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, ObjectType type) {
        super.doEncode(encoded, type);
        encoded.put("properties", type.getProperties().stream().map(JetLinksPropertyMetadata::new).map(Jsonable::toJson).collect(Collectors.toList()));
    }
}

