/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import org.jetlinks.core.Payload;
import org.jetlinks.core.utils.BytesUtils;

public class RpcRequest
implements Payload {
    private static final Type[] types = Type.values();
    private final Type type;
    private final long requestId;
    private final ByteBuf body;

    public static RpcRequest parse(Payload payload) {
        return new RpcRequest(payload);
    }

    public static RpcRequest next(long requestId, Payload payload) {
        return new RpcRequest(Type.NEXT, requestId, payload);
    }

    public static RpcRequest complete(long requestId) {
        return new RpcRequest(Type.COMPLETE, requestId, voidPayload);
    }

    public static RpcRequest nextAndComplete(long requestId, Payload payload) {
        return new RpcRequest(Type.NEXT_AND_END, requestId, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcRequest(Type type, long requestId, Payload payload) {
        try {
            ByteBuf body = payload.getBody();
            ByteBuf byteBuf = Unpooled.buffer((int)(9 + body.capacity()));
            byteBuf.writeByte(type.ordinal());
            byteBuf.writeBytes(BytesUtils.longToBe((long)requestId));
            byteBuf.writeBytes(body);
            this.type = type;
            this.body = byteBuf;
            this.requestId = requestId;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)payload);
        }
    }

    private RpcRequest(Payload payload) {
        ByteBuf byteBuf = payload.getBody();
        this.type = types[byteBuf.readByte()];
        byte[] msgId = new byte[8];
        byteBuf.getBytes(1, msgId);
        this.requestId = BytesUtils.beToLong((byte[])msgId);
        this.body = byteBuf.copy(9, byteBuf.capacity() - 9);
        byteBuf.resetReaderIndex();
        ReferenceCountUtil.safeRelease((Object)payload);
    }

    public Type getType() {
        return this.type;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public ByteBuf getBody() {
        return this.body;
    }

    public static enum Type {
        NEXT,
        COMPLETE,
        NEXT_AND_END;

    }
}

