/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.event;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RSocketPayload
implements Payload {
    private static final Logger log = LoggerFactory.getLogger(RSocketPayload.class);
    private io.rsocket.Payload payload;
    private ByteBuf data;

    public static RSocketPayload of(io.rsocket.Payload payload) {
        return RSocketPayload.of(payload, Unpooled.unreleasableBuffer((ByteBuf)payload.data()));
    }

    public Payload slice() {
        if (this.payload == null) {
            throw new IllegalStateException("payload released");
        }
        return RSocketPayload.of(this.payload, this.data.slice());
    }

    @Nonnull
    public ByteBuf getBody() {
        if (this.data == null) {
            throw new IllegalStateException("payload released");
        }
        return this.data;
    }

    public boolean release() {
        return this.handleRelease(ReferenceCountUtil.release((Object)this.payload));
    }

    public boolean release(int dec) {
        return this.handleRelease(ReferenceCountUtil.release((Object)this.payload, (int)dec));
    }

    protected boolean handleRelease(boolean released) {
        if (released) {
            this.payload = null;
            this.data = null;
        }
        return released;
    }

    public RSocketPayload retain() {
        ReferenceCountUtil.retain((Object)this.payload);
        return this;
    }

    public RSocketPayload retain(int inc) {
        ReferenceCountUtil.retain((Object)this.payload, (int)inc);
        return this;
    }

    public int refCnt() {
        return this.payload == null ? 0 : ReferenceCountUtil.refCnt((Object)this.payload);
    }

    public String bodyToString() {
        return this.bodyToString(true);
    }

    public String bodyToString(boolean release) {
        try {
            if (this.payload == null) {
                throw new IllegalStateException("payload released");
            }
            String string = this.data.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (release) {
                ReferenceCountUtil.safeRelease((Object)this);
            }
        }
    }

    protected void finalize() throws Throwable {
        int refCnt = ReferenceCountUtil.refCnt((Object)this.payload);
        if (refCnt > 0) {
            log.debug("payload {} was not release properly, release() was not called before it's garbage-collected. refCnt={}", (Object)this.payload, (Object)refCnt);
        }
        super.finalize();
    }

    @ConstructorProperties(value={"payload", "data"})
    private RSocketPayload(io.rsocket.Payload payload, ByteBuf data) {
        this.payload = payload;
        this.data = data;
    }

    public static RSocketPayload of(io.rsocket.Payload payload, ByteBuf data) {
        return new RSocketPayload(payload, data);
    }
}

