/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.util.ReferenceCountUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.supports.cluster.EventBusLocalCache;
import org.jetlinks.supports.config.ClusterConfigStorage;
import reactor.core.publisher.Mono;

public class EventBusStorageManager
implements ConfigStorageManager {
    private final ConcurrentMap<String, ClusterConfigStorage> cache;
    private final Supplier<Cache<String, Object>> cacheSupplier;
    private final Function<String, ClusterConfigStorage> storageBuilder;

    public EventBusStorageManager(ClusterManager clusterManager, EventBus eventBus) {
        this(clusterManager, eventBus, () -> CacheBuilder.newBuilder().build());
    }

    public EventBusStorageManager(ClusterManager clusterManager, EventBus eventBus, Supplier<Cache<String, Object>> supplier) {
        this.cache = supplier.get().asMap();
        this.cacheSupplier = supplier;
        this.storageBuilder = id -> new ClusterConfigStorage(new EventBusLocalCache<String, Object>((String)id, eventBus, clusterManager, this.cacheSupplier.get()));
        eventBus.subscribe(Subscription.of((String)"event-bus-storage-listener", (String[])new String[]{"/_sys/cluster_cache/*/*/*"}, (Subscription.Feature[])new Subscription.Feature[]{Subscription.Feature.broker})).subscribe(payload -> {
            try {
                Map vars = payload.getTopicVars("/_sys/cluster_cache/{name}/{type}/{key}");
                ClusterConfigStorage storage = (ClusterConfigStorage)this.cache.get(vars.get("name"));
                if (storage != null) {
                    EventBusLocalCache eventBusLocalCache = (EventBusLocalCache)storage.getCache();
                    eventBusLocalCache.clearLocalCache(vars.get("key"));
                }
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)payload);
            }
        });
    }

    public Mono<ConfigStorage> getStorage(String id) {
        return Mono.just((Object)this.cache.computeIfAbsent(id, this.storageBuilder));
    }
}

