/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.ipc.IpcService;
import org.jetlinks.core.rpc.DisposableService;
import org.jetlinks.core.rpc.RpcServiceFactory;
import org.jetlinks.supports.rpc.ServiceConsumer;
import org.jetlinks.supports.rpc.ServiceProducer;
import reactor.core.Disposable;

public class IpcRpcServiceFactory
implements RpcServiceFactory {
    private final IpcService ipcService;
    static ResponseCodec responseCodec = new ResponseCodec();

    public <T> DisposableService<T> createProducer(String address, Class<T> serviceInterface) {
        return new ServiceProducer<T>(address, this.ipcService, serviceInterface);
    }

    public <T> Disposable createConsumer(String address, Class<T> serviceInterface, T instance) {
        return new ServiceConsumer(this.ipcService, address, instance, serviceInterface);
    }

    @ConstructorProperties(value={"ipcService"})
    public IpcRpcServiceFactory(IpcService ipcService) {
        this.ipcService = ipcService;
    }

    static class ResponseCodec
    implements Codec<Payload> {
        ResponseCodec() {
        }

        public Class<Payload> forType() {
            return Payload.class;
        }

        public Payload decode(@Nonnull Payload payload) {
            return Payload.of((ByteBuf)payload.getBody().copy());
        }

        public Payload encode(Payload body) {
            return body;
        }
    }
}

