/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.supports.rpc.MethodRequest;

public class MethodRequestCodec
implements Codec<MethodRequest> {
    private final List<Codec<Object>> parameterCodecs;

    private MethodRequestCodec(List<Codec<Object>> parameterCodecs) {
        this.parameterCodecs = parameterCodecs;
    }

    public static MethodRequestCodec of(List<Codec<?>> parameterCodecs) {
        return new MethodRequestCodec(parameterCodecs);
    }

    public Class<MethodRequest> forType() {
        return MethodRequest.class;
    }

    public static MethodRequest decode(Payload payload, BiFunction<String, Integer, List<Codec<Object>>> argCodecGetter) {
        ByteBuf body = payload.getBody();
        int index = body.readerIndex();
        int methodLen = body.getInt(index);
        byte[] methodNameBytes = new byte[methodLen];
        body.getBytes(index += 4, methodNameBytes);
        index += methodLen;
        String methodName = new String(methodNameBytes);
        Object[] args = null;
        byte argCount = body.getByte(index++);
        List<Codec<Object>> parameterCodecs = argCodecGetter.apply(methodName, Integer.valueOf(argCount));
        if (!parameterCodecs.isEmpty()) {
            int argSize = parameterCodecs.size();
            args = new Object[argSize];
            for (int i = 0; i < argSize; ++i) {
                ByteBuf buf;
                Codec<Object> codec = parameterCodecs.get(i);
                int argLen = body.getInt(index);
                index += 4;
                if (argLen < 0) continue;
                if (argLen == 0) {
                    buf = Unpooled.EMPTY_BUFFER;
                } else {
                    buf = ByteBufAllocator.DEFAULT.buffer(argLen);
                    body.getBytes(index, buf);
                }
                args[i] = Payload.of((ByteBuf)buf).decode(codec);
                index += argLen;
            }
        }
        return MethodRequest.of(methodName, args);
    }

    public MethodRequest decode(@Nonnull Payload payload) {
        return MethodRequestCodec.decode(payload, (methodName, size) -> this.parameterCodecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Payload encode(MethodRequest body) {
        Object[] args = body.getArgs();
        byte[] name = body.getMethod().getBytes();
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        byteBuf.writeInt(name.length);
        byteBuf.writeBytes(name);
        byteBuf.writeByte(this.parameterCodecs.size());
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Codec<Object> encoder = this.parameterCodecs.get(i);
                Payload payload = encoder.encode(arg);
                try {
                    ByteBuf argBuf = payload.getBody();
                    byteBuf.writeInt(argBuf.writerIndex());
                    byteBuf.writeBytes(argBuf);
                    continue;
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)payload);
                }
            }
        }
        return Payload.of((ByteBuf)byteBuf);
    }
}

