/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.ipc.IpcDefinition;
import org.jetlinks.core.ipc.IpcInvoker;
import org.jetlinks.core.ipc.IpcInvokerBuilder;
import org.jetlinks.core.ipc.IpcService;
import org.jetlinks.core.rpc.DisposableService;
import org.jetlinks.supports.ipc.RequestType;
import org.jetlinks.supports.rpc.IpcRpcServiceFactory;
import org.jetlinks.supports.rpc.MethodRequest;
import org.jetlinks.supports.rpc.MethodRequestCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceProducer<T>
implements DisposableService<T> {
    private final Class<T> serviceInterface;
    private final T service;
    private final Logger log;
    private final Disposable disposable;

    public ServiceProducer(String address, IpcService ipcService, Class<T> serviceInterface) {
        this.serviceInterface = serviceInterface;
        HashMap<Method, Function<Object[], Object>> invokers = new HashMap<Method, Function<Object[], Object>>();
        IpcInvoker remote = ipcService.createInvoker(serviceInterface.getName(), IpcDefinition.of((String)address, (Codec)IpcRpcServiceFactory.responseCodec, (Codec)IpcRpcServiceFactory.responseCodec));
        remote = IpcInvokerBuilder.forTimeout((Duration)Duration.ofSeconds(10L), (IpcInvoker)remote);
        this.disposable = remote;
        for (Method method2 : serviceInterface.getMethods()) {
            invokers.put(method2, this.createInvoker((IpcInvoker<Payload, Payload>)remote, method2));
        }
        this.log = LoggerFactory.getLogger(serviceInterface);
        InvocationHandler handler = (proxy, method, args) -> {
            Function invoker = (Function)invokers.get(method);
            this.log.debug("invoke method:{}", (Object)method.getName());
            return invoker.apply(args);
        };
        this.service = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceInterface}, handler);
    }

    private Function<Object[], Object> createInvoker(IpcInvoker<Payload, Payload> remote, Method method) {
        ResolvableType returnType = ResolvableType.forMethodReturnType((Method)method);
        ArrayList<ResolvableType> argTypes = new ArrayList<ResolvableType>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            argTypes.add(ResolvableType.forMethodParameter((Method)method, (int)i));
        }
        String methodName = method.getName();
        List<Codec<?>> codecs = argTypes.stream().map(Codecs::lookup).collect(Collectors.toList());
        MethodRequestCodec codec = MethodRequestCodec.of(codecs);
        Codec responseCodec = Codecs.lookup((ResolvableType)returnType);
        RequestType requestType = this.getRpcType(argTypes, returnType);
        switch (requestType) {
            case request: {
                return args -> remote.request((Object)codec.encode(MethodRequest.of(methodName, args))).map(response -> response.decode((Decoder)responseCodec));
            }
            case noArgRequest: {
                return args -> remote.request((Object)codec.encode(MethodRequest.of(methodName, null))).map(response -> response.decode((Decoder)responseCodec));
            }
            case requestStream: {
                return args -> remote.requestStream((Object)codec.encode(MethodRequest.of(methodName, args))).map(response -> response.decode((Decoder)responseCodec));
            }
            case noArgRequestStream: {
                return args -> remote.requestStream((Object)codec.encode(MethodRequest.of(methodName, null))).map(response -> response.decode((Decoder)responseCodec));
            }
        }
        throw new UnsupportedOperationException("unsupported rpc method:" + method);
    }

    protected RequestType getRpcType(List<ResolvableType> argTypes, ResolvableType returnType) {
        boolean hasArg = argTypes.size() > 0;
        Class returnClass = returnType.toClass();
        boolean argHasStream = argTypes.stream().anyMatch(type -> Publisher.class.isAssignableFrom(type.toClass()));
        if (hasArg && argHasStream) {
            throw new UnsupportedOperationException("unsupported publisher arg yet");
        }
        if (Mono.class.isAssignableFrom(returnClass)) {
            if (hasArg) {
                return RequestType.request;
            }
            return RequestType.noArgRequest;
        }
        if (Flux.class.isAssignableFrom(returnClass)) {
            if (hasArg) {
                return RequestType.requestStream;
            }
            return RequestType.noArgRequestStream;
        }
        return hasArg ? RequestType.fireAndForget : RequestType.noArgFireAndForget;
    }

    public T getService() {
        return this.service;
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public String toString() {
        return this.serviceInterface.toString();
    }
}

