/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.cache.Caches;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.defaults.DefaultDeviceOperator;
import org.jetlinks.core.defaults.DefaultDeviceProductOperator;
import org.jetlinks.core.device.CompositeDeviceMessageSenderInterceptor;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperationBroker;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.device.DeviceStateInfo;
import org.jetlinks.core.device.ProductInfo;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.supports.cluster.CompositeDeviceStateChecker;
import org.jetlinks.supports.config.ClusterConfigStorageManager;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ClusterDeviceRegistry
implements DeviceRegistry {
    private final CompositeDeviceMessageSenderInterceptor interceptor = new CompositeDeviceMessageSenderInterceptor();
    private final ConfigStorageManager manager;
    private final Cache<String, DeviceOperator> operatorCache;
    private final Map<String, DeviceProductOperator> productOperatorMap = Caches.newCache();
    private final ProtocolSupports supports;
    private final DeviceOperationBroker handler;
    private final ClusterManager clusterManager;
    private final CompositeDeviceStateChecker stateChecker = new CompositeDeviceStateChecker();

    public ClusterDeviceRegistry(ProtocolSupports supports, ClusterManager clusterManager, DeviceOperationBroker handler) {
        this(supports, clusterManager, handler, (Cache<String, DeviceOperator>)CacheBuilder.newBuilder().softValues().expireAfterAccess(Duration.ofMinutes(30L)).build());
    }

    public ClusterDeviceRegistry(ProtocolSupports supports, ConfigStorageManager storageManager, ClusterManager clusterManager, DeviceOperationBroker handler, Cache<String, DeviceOperator> cache) {
        this.supports = supports;
        this.handler = handler;
        this.manager = storageManager;
        this.operatorCache = cache;
        this.clusterManager = clusterManager;
        this.addStateChecker(DefaultDeviceOperator.DEFAULT_STATE_CHECKER);
    }

    public ClusterDeviceRegistry(ProtocolSupports supports, ClusterManager clusterManager, DeviceOperationBroker handler, Cache<String, DeviceOperator> cache) {
        this.supports = supports;
        this.handler = handler;
        this.manager = new ClusterConfigStorageManager(clusterManager);
        this.operatorCache = cache;
        this.clusterManager = clusterManager;
        this.addStateChecker(DefaultDeviceOperator.DEFAULT_STATE_CHECKER);
    }

    public Flux<DeviceStateInfo> checkDeviceState(Flux<? extends Collection<String>> id) {
        return id.flatMap(list -> Flux.fromIterable((Iterable)list).flatMap(this::getDevice).flatMap(device -> device.getConnectionServerId().defaultIfEmpty((Object)"__").zipWith(Mono.just((Object)device))).groupBy(Tuple2::getT1, Tuple2::getT2).flatMap(group -> {
            if (!StringUtils.hasText((String)((String)group.key())) || "__".equals(group.key())) {
                return group.flatMap(operator -> operator.getState().map(state -> new DeviceStateInfo(operator.getDeviceId(), state.byteValue())));
            }
            return group.map(DeviceOperator::getDeviceId).collectList().flatMapMany(deviceIdList -> this.handler.getDeviceState((String)group.key(), (Collection)deviceIdList));
        }));
    }

    public Mono<DeviceOperator> getDevice(String deviceId) {
        if (StringUtils.isEmpty((Object)deviceId)) {
            return Mono.empty();
        }
        DeviceOperator deviceOperator = (DeviceOperator)this.operatorCache.getIfPresent((Object)deviceId);
        if (null != deviceOperator) {
            return Mono.just((Object)deviceOperator);
        }
        deviceOperator = this.createOperator(deviceId);
        return deviceOperator.getSelfConfig((ConfigKey)DeviceConfigKey.productId).doOnNext(r -> this.operatorCache.put((Object)deviceId, (Object)deviceOperator)).map(r -> deviceOperator);
    }

    public Mono<DeviceProductOperator> getProduct(String productId) {
        if (StringUtils.isEmpty((Object)productId)) {
            return Mono.empty();
        }
        DeviceProductOperator operator = this.productOperatorMap.get(productId);
        if (null != operator) {
            return Mono.just((Object)operator);
        }
        DefaultDeviceProductOperator deviceOperator = this.createProductOperator(productId);
        return deviceOperator.getConfig((ConfigKey)DeviceConfigKey.protocol).doOnNext(arg_0 -> this.lambda$getProduct$8(productId, (DeviceProductOperator)deviceOperator, arg_0)).map(arg_0 -> ClusterDeviceRegistry.lambda$getProduct$9((DeviceProductOperator)deviceOperator, arg_0));
    }

    private DefaultDeviceOperator createOperator(String deviceId) {
        return new DefaultDeviceOperator(deviceId, this.supports, this.manager, this.handler, (DeviceRegistry)this, (DeviceMessageSenderInterceptor)this.interceptor, (DeviceStateChecker)this.stateChecker);
    }

    private DefaultDeviceProductOperator createProductOperator(String id) {
        return new DefaultDeviceProductOperator(id, this.supports, this.manager, () -> this.clusterManager.getSet("device-product-bind:" + id).values().flatMap(this::getDevice));
    }

    public Mono<DeviceOperator> register(DeviceInfo deviceInfo) {
        return Mono.defer(() -> {
            DefaultDeviceOperator operator = this.createOperator(deviceInfo.getId());
            this.operatorCache.put((Object)operator.getDeviceId(), (Object)operator);
            HashMap configs = new HashMap();
            Optional.ofNullable(deviceInfo.getMetadata()).ifPresent(conf -> configs.put(DeviceConfigKey.metadata.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProtocol()).ifPresent(conf -> configs.put(DeviceConfigKey.protocol.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProductId()).ifPresent(conf -> configs.put(DeviceConfigKey.productId.getKey(), conf));
            Optional.ofNullable(deviceInfo.getConfiguration()).ifPresent(configs::putAll);
            return operator.setConfigs(configs).then(operator.getProtocol()).flatMap(protocol -> protocol.onDeviceRegister((DeviceOperator)operator)).then(this.clusterManager.getSet("device-product-bind:" + deviceInfo.getProductId()).add((Object)deviceInfo.getId())).thenReturn((Object)operator);
        });
    }

    public Mono<DeviceProductOperator> register(ProductInfo productInfo) {
        return Mono.defer(() -> {
            DefaultDeviceProductOperator operator = this.createProductOperator(productInfo.getId());
            this.productOperatorMap.put(operator.getId(), (DeviceProductOperator)operator);
            HashMap configs = new HashMap();
            Optional.ofNullable(productInfo.getMetadata()).ifPresent(conf -> configs.put(DeviceConfigKey.metadata.getKey(), conf));
            Optional.ofNullable(productInfo.getProtocol()).ifPresent(conf -> configs.put(DeviceConfigKey.protocol.getKey(), conf));
            Optional.ofNullable(productInfo.getConfiguration()).ifPresent(configs::putAll);
            return operator.setConfigs(configs).then(operator.getProtocol()).flatMap(protocol -> protocol.onProductRegister((DeviceProductOperator)operator)).thenReturn((Object)operator);
        });
    }

    public Mono<Void> unregisterDevice(String deviceId) {
        return this.getDevice(deviceId).flatMap(device -> device.getProtocol().flatMap(protocol -> protocol.onDeviceUnRegister(device))).then(this.manager.getStorage("device:" + deviceId).flatMap(ConfigStorage::clear)).doFinally(r -> this.operatorCache.invalidate((Object)deviceId)).then();
    }

    public Mono<Void> unregisterProduct(String productId) {
        return this.getProduct(productId).flatMap(product -> product.getProtocol().flatMap(protocol -> protocol.onProductUnRegister(product))).then(this.manager.getStorage("device-product:" + productId).flatMap(ConfigStorage::clear)).doFinally(s -> this.productOperatorMap.remove(productId)).then();
    }

    public void addInterceptor(DeviceMessageSenderInterceptor interceptor) {
        this.interceptor.addInterceptor(interceptor);
    }

    public void addStateChecker(DeviceStateChecker deviceStateChecker) {
        this.stateChecker.addDeviceStateChecker(deviceStateChecker);
    }

    private static /* synthetic */ DeviceProductOperator lambda$getProduct$9(DeviceProductOperator deviceOperator, String r) {
        return deviceOperator;
    }

    private /* synthetic */ void lambda$getProduct$8(String productId, DeviceProductOperator deviceOperator, String r) {
        this.productOperatorMap.put(productId, deviceOperator);
    }
}

