/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.ipc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.beans.ConstructorProperties;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.codec.Encoder;
import org.jetlinks.supports.ipc.RequestType;

public class IpcRequest<T> {
    private static final RequestType[] types = RequestType.values();
    private final RequestType type;
    private final int consumerId;
    private final int messageId;
    private final int seq;
    private final T request;

    public static <T> IpcRequest<T> of(RequestType type, int consumerId, int messageId, T request) {
        return IpcRequest.of(type, consumerId, messageId, -1, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> IpcRequest<T> decode(Payload payload, Decoder<T> decoder) {
        try {
            ByteBuf body = payload.getBody();
            byte type = body.readByte();
            if (type < 0 || type >= types.length) {
                throw new IllegalStateException("unknown request type " + type);
            }
            RequestType requestType = types[type];
            int invokeId = body.readInt();
            int messageId = body.readInt();
            int seq = body.readInt();
            boolean hasBody = body.readByte() == 1;
            Object requestBody = null;
            if (hasBody) {
                requestBody = decoder.decode(payload);
            }
            IpcRequest<Object> ipcRequest = IpcRequest.of(requestType, invokeId, messageId, seq, requestBody);
            return ipcRequest;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)payload);
        }
    }

    public ByteBuf toByteBuf(Encoder<T> encoder) {
        ByteBuf ref;
        ByteBuf body;
        ByteBuf buf;
        if (this.request == null) {
            buf = ByteBufAllocator.DEFAULT.buffer(9);
            ref = body = Unpooled.EMPTY_BUFFER;
        } else {
            Payload payload = encoder.encode(this.request);
            body = payload.getBody();
            buf = ByteBufAllocator.DEFAULT.buffer(9 + body.writerIndex());
            ref = payload;
        }
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.consumerId);
        buf.writeInt(this.messageId);
        buf.writeInt(this.seq);
        buf.writeByte(this.request == null ? 0 : 1);
        buf.writeBytes(body);
        ReferenceCountUtil.safeRelease((Object)ref);
        return buf;
    }

    @ConstructorProperties(value={"type", "consumerId", "messageId", "seq", "request"})
    private IpcRequest(RequestType type, int consumerId, int messageId, int seq, T request) {
        this.type = type;
        this.consumerId = consumerId;
        this.messageId = messageId;
        this.seq = seq;
        this.request = request;
    }

    public static <T> IpcRequest<T> of(RequestType type, int consumerId, int messageId, int seq, T request) {
        return new IpcRequest<T>(type, consumerId, messageId, seq, request);
    }

    public RequestType getType() {
        return this.type;
    }

    public int getConsumerId() {
        return this.consumerId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public int getSeq() {
        return this.seq;
    }

    public T getRequest() {
        return this.request;
    }
}

