/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.unit.ValueUnits;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksFloatCodec
extends AbstractDataTypeCodec<FloatType> {
    public String getTypeId() {
        return "float";
    }

    @Override
    public FloatType decode(FloatType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getFloat("max")).ifPresent(arg_0 -> ((FloatType)type).setMax(arg_0));
        Optional.ofNullable(jsonObject.getFloat("min")).ifPresent(arg_0 -> ((FloatType)type).setMin(arg_0));
        Optional.ofNullable(jsonObject.getInteger("scale")).ifPresent(arg_0 -> ((FloatType)type).setScale(arg_0));
        Optional.ofNullable(jsonObject.getString("unit")).flatMap(ValueUnits::lookup).ifPresent(arg_0 -> ((FloatType)type).setUnit(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, FloatType type) {
        encoded.put("max", type.getMax());
        encoded.put("min", type.getMin());
        encoded.put("scale", type.getScale());
        if (type.getUnit() != null) {
            encoded.put("unit", type.getUnit().getId());
        }
    }
}

