/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.unit.ValueUnits;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksIntCodec
extends AbstractDataTypeCodec<IntType> {
    public String getTypeId() {
        return "int";
    }

    @Override
    public IntType decode(IntType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getInteger("max")).ifPresent(arg_0 -> ((IntType)type).setMax(arg_0));
        Optional.ofNullable(jsonObject.getInteger("min")).ifPresent(arg_0 -> ((IntType)type).setMin(arg_0));
        Optional.ofNullable(jsonObject.getString("unit")).flatMap(ValueUnits::lookup).ifPresent(arg_0 -> ((IntType)type).setUnit(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, IntType type) {
        encoded.put("max", type.getMax());
        encoded.put("min", type.getMin());
        if (type.getUnit() != null) {
            encoded.put("unit", type.getUnit().getId());
        }
    }
}

