/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.jetlinks.supports.protocol.codec.BinaryDecoder;

public interface CodecPredicate {
    public boolean test(byte[] var1, int var2);

    public static <L, R> CodecPredicate of(BinaryDecoder<L> leftDecoder, BinaryDecoder<R> rightDecoder, BiPredicate<L, R> predicate) {
        return (body, offset) -> predicate.test(leftDecoder.decode(body, offset), rightDecoder.decode(body, offset));
    }

    default public CodecPredicate or(CodecPredicate predicate) {
        return (body, offset) -> this.test(body, offset) || predicate.test(body, offset);
    }

    default public CodecPredicate and(CodecPredicate predicate) {
        return (body, offset) -> this.test(body, offset) && predicate.test(body, offset);
    }

    public static <L, R extends L> CodecPredicate eq(BinaryDecoder<L> leftDecoder, BinaryDecoder<R> rightDecoder) {
        return CodecPredicate.of(leftDecoder, rightDecoder, Objects::deepEquals);
    }

    public static CodecPredicate not(BinaryDecoder<?> leftDecoder, BinaryDecoder<?> rightDecoder) {
        return CodecPredicate.of(leftDecoder, rightDecoder, (l, r) -> !Objects.deepEquals(l, r));
    }

    public static CodecPredicate gt(BinaryDecoder<Number> leftDecoder, BinaryDecoder<Number> rightDecoder) {
        return CodecPredicate.of(leftDecoder, rightDecoder, (l, r) -> l.doubleValue() > r.doubleValue());
    }

    public static CodecPredicate lt(BinaryDecoder<Number> leftDecoder, BinaryDecoder<Number> rightDecoder) {
        return CodecPredicate.of(leftDecoder, rightDecoder, (l, r) -> l.doubleValue() < r.doubleValue());
    }

    public static CodecPredicate lte(BinaryDecoder<Number> leftDecoder, BinaryDecoder<Number> rightDecoder) {
        return CodecPredicate.of(leftDecoder, rightDecoder, (l, r) -> l.doubleValue() <= r.doubleValue());
    }

    public static CodecPredicate gte(BinaryDecoder<Number> leftDecoder, BinaryDecoder<Number> rightDecoder) {
        return CodecPredicate.of(leftDecoder, rightDecoder, (l, r) -> l.doubleValue() >= r.doubleValue());
    }
}

