/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import java.beans.ConstructorProperties;
import org.jetlinks.supports.protocol.codec.BinaryCodec;
import org.jetlinks.supports.protocol.codec.Endian;

public class Ieee754FloatCodec
implements BinaryCodec<Float> {
    private final Endian endian;
    private final int offset;

    @Override
    public Float decode(byte[] payload, int offset) {
        return Float.valueOf(Float.intBitsToFloat((int)this.endian.decode(payload, this.offset + offset, 4)));
    }

    @Override
    public void encode(Float part, byte[] payload, int offset) {
        this.endian.encode(Float.floatToIntBits(part.floatValue()), payload, this.offset + offset, 4);
    }

    @ConstructorProperties(value={"endian", "offset"})
    private Ieee754FloatCodec(Endian endian, int offset) {
        this.endian = endian;
        this.offset = offset;
    }

    public static Ieee754FloatCodec of(Endian endian, int offset) {
        return new Ieee754FloatCodec(endian, offset);
    }
}

