/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import java.beans.ConstructorProperties;
import org.jetlinks.supports.protocol.codec.BinaryCodec;
import org.jetlinks.supports.protocol.codec.Endian;

public class LongCodec
implements BinaryCodec<Long> {
    private final Endian endian;
    private final int offset;
    private final int length;

    @Override
    public Long decode(byte[] payload, int offset) {
        return this.endian.decode(payload, this.offset + offset, this.length);
    }

    @Override
    public void encode(Long part, byte[] payload, int offset) {
        this.endian.encode(part, payload, this.offset + offset, this.length);
    }

    @ConstructorProperties(value={"endian", "offset", "length"})
    private LongCodec(Endian endian, int offset, int length) {
        this.endian = endian;
        this.offset = offset;
        this.length = length;
    }

    public static LongCodec of(Endian endian, int offset, int length) {
        return new LongCodec(endian, offset, length);
    }
}

