/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.supports.protocol.StaticProtocolSupports;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.ProtocolSupportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementProtocolSupports
extends StaticProtocolSupports {
    private static final Logger log = LoggerFactory.getLogger(ManagementProtocolSupports.class);
    private ProtocolSupportManager manager;
    private ProtocolSupportLoader loader;
    private ClusterManager clusterManager;
    private Map<String, String> configProtocolIdMapping = new ConcurrentHashMap<String, String>();

    public void init() {
        this.manager.loadAll().filter(de -> de.getState() == 1).subscribe(this::init);
        this.clusterManager.getTopic("_protocol_changed").subscribe().subscribe(this::init);
    }

    public void init(ProtocolSupportDefinition definition) {
        String protocol;
        if (definition.getState() != 1 && (protocol = this.configProtocolIdMapping.get(definition.getId())) != null) {
            log.debug("uninstall protocol:{}", (Object)definition);
            this.unRegister(protocol);
            return;
        }
        String operation = definition.getState() != 1 ? "uninstall" : "install";
        Consumer<ProtocolSupport> consumer = definition.getState() != 1 ? this::unRegister : this::register;
        log.debug("{} protocol:{}", (Object)operation, (Object)definition);
        try {
            this.loader.load(definition).doOnNext(protocolSupport -> protocolSupport.init(definition.getConfiguration())).doOnError(e -> log.error("{} protocol[{}] error: {}", new Object[]{operation, definition.getId(), e})).doOnNext(e -> log.debug("{} protocol[{}] success: {}", new Object[]{operation, definition.getId(), e})).doOnNext(e -> this.configProtocolIdMapping.put(definition.getId(), e.getId())).subscribe(consumer);
        }
        catch (Exception e2) {
            log.error("load protocol error:{}", (Object)definition, (Object)e2);
        }
    }

    public void setManager(ProtocolSupportManager manager) {
        this.manager = manager;
    }

    public void setLoader(ProtocolSupportLoader loader) {
        this.loader = loader;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setConfigProtocolIdMapping(Map<String, String> configProtocolIdMapping) {
        this.configProtocolIdMapping = configProtocolIdMapping;
    }
}

