/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cache;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetlinks.core.Payload;
import org.jetlinks.core.cache.FileQueue;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.config.ConfigKey;
import org.springframework.util.Assert;

class MVStoreQueue<T>
implements FileQueue<T> {
    private MVStore store;
    private MVMap<Long, byte[]> mvMap;
    private final AtomicLong index = new AtomicLong();
    private final Codec<T> codec;
    private final String name;
    private final Path storageFile;

    MVStoreQueue(Path filePath, String name, Codec<T> codec) {
        Files.createDirectories(filePath, new FileAttribute[0]);
        this.name = name;
        this.storageFile = filePath.resolve(name);
        this.codec = codec;
        this.open();
    }

    protected void open() {
        try {
            if (this.store != null && !this.store.isClosed()) {
                this.store.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String path = this.storageFile.toUri().getScheme().equals("jimfs") ? this.storageFile.toUri().toString() : this.storageFile.toString();
        this.store = new MVStore.Builder().fileName(path).cacheSize(1).autoCommitDisabled().open();
        this.mvMap = this.store.openMap(this.name);
        if (!this.mvMap.isEmpty()) {
            this.index.set((Long)this.mvMap.lastKey());
        }
    }

    public void flush() {
        if (this.store.isClosed()) {
            return;
        }
        this.store.commit();
        this.store.sync();
    }

    public synchronized void close() {
        if (this.store.isClosed()) {
            return;
        }
        this.store.sync();
        this.store.close();
    }

    private void checkClose() {
        if (this.store.isClosed()) {
            throw new IllegalStateException("file queue " + this.name + " is closed");
        }
    }

    private byte[] encode(T data) {
        return this.codec.encode(data).getBytes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T decode(byte[] data) {
        if (data == null) {
            return null;
        }
        Payload payload = Payload.of((byte[])data);
        Object val = null;
        try {
            val = this.codec.decode(payload);
        }
        finally {
            if (!(val instanceof Payload)) {
                payload.release();
            }
        }
        return (T)val;
    }

    public int size() {
        this.checkClose();
        return this.mvMap.size();
    }

    public boolean isEmpty() {
        this.checkClose();
        return this.mvMap.isEmpty();
    }

    public boolean contains(Object o) {
        this.checkClose();
        return this.mvMap.containsValue(o);
    }

    @Nonnull
    public Iterator<T> iterator() {
        this.checkClose();
        final Cursor cursor = this.mvMap.cursor(this.mvMap.firstKey());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public T next() {
                return MVStoreQueue.this.decode((byte[])cursor.getValue());
            }
        };
    }

    @Nonnull
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        this.checkClose();
        return this.stream().toArray(i -> a);
    }

    public boolean add(T t) {
        this.checkClose();
        if (null == t) {
            return false;
        }
        byte[] val = this.encode(t);
        while ((val = (byte[])this.mvMap.put((Object)this.index.incrementAndGet(), (Object)val)) != null) {
        }
        return true;
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove unsupported");
    }

    public boolean containsAll(Collection<?> c) {
        this.checkClose();
        return this.mvMap.values().containsAll(c);
    }

    public boolean addAll(Collection<? extends T> c) {
        this.checkClose();
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll unsupported");
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll unsupported");
    }

    public void clear() {
        if (this.mvMap.isClosed()) {
            return;
        }
        this.mvMap.clear();
        this.index.set(0L);
    }

    public boolean offer(T t) {
        this.checkClose();
        return this.add(t);
    }

    public T remove() {
        this.checkClose();
        T data = this.poll();
        if (data == null) {
            throw new NoSuchElementException("No such element in file " + this.storageFile);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        byte[] removed;
        if (this.mvMap.isClosed()) {
            return null;
        }
        MVStoreQueue mVStoreQueue = this;
        synchronized (mVStoreQueue) {
            Long key = (Long)this.mvMap.firstKey();
            byte[] byArray = removed = key == null ? null : (byte[])this.mvMap.remove((Object)key);
            if (removed == null) {
                this.index.set(0L);
                return null;
            }
        }
        return this.decode(removed);
    }

    public T element() {
        if (this.mvMap.isClosed()) {
            return null;
        }
        T data = this.peek();
        if (data == null) {
            throw new NoSuchElementException("No such element in file " + this.storageFile);
        }
        return data;
    }

    public T peek() {
        this.checkClose();
        byte[] value = (byte[])this.mvMap.get(this.mvMap.firstKey());
        return this.decode(value);
    }

    static class Builder<T>
    implements FileQueue.Builder<T> {
        private String name;
        private Codec<T> codec;
        private Path path;

        Builder() {
        }

        public FileQueue.Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public FileQueue.Builder<T> codec(Codec<T> codec) {
            this.codec = codec;
            return this;
        }

        public FileQueue.Builder<T> path(Path path) {
            this.path = path;
            return this;
        }

        public FileQueue.Builder<T> options(Map<String, Object> options) {
            return this;
        }

        public FileQueue.Builder<T> option(String key, Object value) {
            return this;
        }

        public <V> FileQueue.Builder<T> option(ConfigKey<V> key, V value) {
            return this;
        }

        public FileQueue<T> build() {
            Assert.hasText((String)this.name, (String)"name must not be empty");
            Assert.notNull((Object)this.path, (String)"path must not be null");
            Assert.notNull((Object)this.path, (String)"codec must not be null");
            return new MVStoreQueue<T>(this.path, this.name, this.codec);
        }
    }
}

