/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DataTypeCodec;

public abstract class AbstractDataTypeCodec<T extends DataType>
implements DataTypeCodec<T> {
    public T decode(T type, Map<String, Object> config) {
        Optional.ofNullable(config.get("description")).map(String::valueOf).ifPresent(arg_0 -> type.setDescription(arg_0));
        Optional.ofNullable(config.get("expands")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(arg_0 -> type.setExpands(arg_0));
        return type;
    }

    public Map<String, Object> encode(T type) {
        HashMap<String, Object> encoded = new HashMap<String, Object>();
        encoded.put("type", this.getTypeId());
        encoded.put("description", type.getDescription());
        encoded.put("expands", type.getExpands());
        this.doEncode(encoded, type);
        return encoded;
    }

    protected void doEncode(Map<String, Object> encoded, T type) {
    }
}

