/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import org.jetlinks.core.Payload;
import org.jetlinks.core.utils.BytesUtils;

public class RpcRequest
implements Payload {
    private static final Type[] types = Type.values();
    private final Type type;
    private final long requesterId;
    private final long requestId;
    private final ByteBuf body;

    public static RpcRequest parse(Payload payload) {
        return new RpcRequest(payload);
    }

    public static RpcRequest next(long requesterId, long requestId, Payload payload) {
        return new RpcRequest(Type.NEXT, requesterId, requestId, payload);
    }

    public static RpcRequest complete(long requesterId, long requestId) {
        return new RpcRequest(Type.COMPLETE, requesterId, requestId, voidPayload);
    }

    public static RpcRequest nextAndComplete(long requesterId, long requestId, Payload payload) {
        return new RpcRequest(Type.NEXT_AND_END, requesterId, requestId, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcRequest(Type type, long requesterId, long requestId, Payload payload) {
        try {
            ByteBuf body = payload.getBody();
            ByteBuf byteBuf = Unpooled.buffer((int)(17 + body.writerIndex()));
            byteBuf.writeByte(type.ordinal());
            byteBuf.writeBytes(BytesUtils.longToBe((long)requestId));
            byteBuf.writeBytes(BytesUtils.longToBe((long)requesterId));
            byteBuf.writeBytes(body);
            this.type = type;
            this.body = byteBuf;
            this.requestId = requestId;
            this.requesterId = requesterId;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)payload);
        }
    }

    private RpcRequest(Payload payload) {
        ByteBuf byteBuf = payload.getBody();
        this.type = types[byteBuf.readByte()];
        byte[] msgId = new byte[8];
        byte[] reqId = new byte[8];
        byteBuf.getBytes(1, msgId);
        byteBuf.getBytes(9, reqId);
        this.requestId = BytesUtils.beToLong((byte[])msgId);
        this.requesterId = BytesUtils.beToLong((byte[])reqId);
        this.body = byteBuf.copy(17, byteBuf.writerIndex() - 17);
        byteBuf.resetReaderIndex();
        ReferenceCountUtil.safeRelease((Object)payload);
    }

    public Type getType() {
        return this.type;
    }

    public long getRequesterId() {
        return this.requesterId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public ByteBuf getBody() {
        return this.body;
    }

    public static enum Type {
        NEXT,
        COMPLETE,
        NEXT_AND_END;

    }
}

