/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.config;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.event.EventBus;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public class LocalCacheClusterConfigStorage
implements ConfigStorage {
    private final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final String id;
    private final EventBus eventBus;
    private final ClusterCache<String, Object> clusterCache;
    private long expires;
    public static final Value NULL = Value.simple(null);

    private Cache createCache(String key) {
        Cache cache = new Cache();
        cache.init((Mono<Value>)this.clusterCache.get((Object)key).map(Value::simple));
        return cache;
    }

    private Cache getOrCreateCache(String key) {
        return this.caches.computeIfAbsent(key, this::createCache);
    }

    public Mono<Value> getConfig(String key) {
        return this.getOrCreateCache(key).getRef();
    }

    public Mono<Values> getConfigs(Collection<String> keys) {
        HashMap caches = Maps.newHashMapWithExpectedSize((int)keys.size());
        int hits = 0;
        for (String key : keys) {
            Cache local = this.getOrCreateCache(key);
            Value cached = local.getCached();
            if (cached == null) continue;
            ++hits;
            Object obj = cached.get();
            if (null == obj) continue;
            caches.put(key, obj);
        }
        if (hits == keys.size()) {
            return Mono.just((Object)Values.of((Map)caches));
        }
        HashSet<String> needLoadKeys = new HashSet<String>(keys);
        needLoadKeys.removeAll(caches.keySet());
        return this.clusterCache.get(needLoadKeys).reduce((Object)caches, (map, entry) -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.getOrCreateCache(key).setValue(value);
            if (null != value) {
                map.put(key, value);
            }
            return map;
        }).defaultIfEmpty(Collections.emptyMap()).doOnNext(map -> {
            needLoadKeys.removeAll(map.keySet());
            if (needLoadKeys.size() > 0) {
                for (String needLoadKey : needLoadKeys) {
                    this.getOrCreateCache(needLoadKey).setValue(null);
                }
            }
        }).map(Values::of);
    }

    public Mono<Boolean> setConfigs(Map<String, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Mono.just((Object)true);
        }
        values.forEach((key, value) -> this.getOrCreateCache((String)key).setValue(value));
        return this.clusterCache.putAll(values).then(this.notifyRemoveKey("__all")).thenReturn((Object)true);
    }

    public Mono<Boolean> setConfig(String key, Object value) {
        if (key == null) {
            return Mono.just((Object)false);
        }
        if (value == null) {
            return this.remove(key);
        }
        this.getOrCreateCache(key).setValue(value);
        return this.clusterCache.put((Object)key, value).then(this.notifyRemoveKey(key)).thenReturn((Object)true).doOnSuccess(s -> {
            Cache cache = this.caches.get(key);
            if (cache != null) {
                cache.reload();
            }
        });
    }

    public Mono<Boolean> remove(String key) {
        this.caches.remove(key);
        return this.clusterCache.remove((Object)key).then(this.notifyRemoveKey(key)).thenReturn((Object)true);
    }

    public Mono<Value> getAndRemove(String key) {
        return this.clusterCache.getAndRemove((Object)key).flatMap(res -> this.notifyRemoveKey("__all").thenReturn(res)).map(Value::simple);
    }

    public Mono<Boolean> remove(Collection<String> key) {
        key.forEach(this.caches::remove);
        return this.clusterCache.remove(key).then(this.notifyRemoveKey("__all")).thenReturn((Object)true);
    }

    public Mono<Boolean> clear() {
        this.caches.clear();
        return this.clusterCache.clear().then(this.notifyRemoveKey("__all")).thenReturn((Object)true);
    }

    void clearLocalCache(String key) {
        if ("__all".equals(key)) {
            this.caches.clear();
        } else if (key != null) {
            this.caches.remove(key);
        }
    }

    Mono<Void> notifyRemoveKey(String key) {
        return this.eventBus.publish("/_sys/cluster_cache/" + this.id, (Object)key).then();
    }

    public LocalCacheClusterConfigStorage(String id, EventBus eventBus, ClusterCache<String, Object> clusterCache, long expires) {
        this.id = id;
        this.eventBus = eventBus;
        this.clusterCache = clusterCache;
        this.expires = expires;
    }

    class Cache {
        long t = System.currentTimeMillis();
        Mono<Value> dataGetter;
        volatile Mono<Value> ref;
        volatile Value cached;

        Cache() {
        }

        boolean isExpired() {
            return LocalCacheClusterConfigStorage.this.expires > 0L && System.currentTimeMillis() - this.t > LocalCacheClusterConfigStorage.this.expires;
        }

        Mono<Value> getRef() {
            if (this.isExpired()) {
                return this.dataGetter;
            }
            return this.ref;
        }

        public Value getCached() {
            if (this.isExpired()) {
                return null;
            }
            return this.cached;
        }

        void setValue(Object value) {
            this.setValue(value == null ? null : Value.simple((Object)value));
        }

        void setValue(Value value) {
            this.t = System.currentTimeMillis();
            this.ref = Mono.justOrEmpty((Object)value);
            this.cached = value == null ? NULL : value;
        }

        void reload() {
            this.cached = null;
            this.ref = this.dataGetter.cache();
        }

        void init(Mono<Value> dataGetter) {
            this.dataGetter = dataGetter.doOnNext(this::setValue).switchIfEmpty(Mono.fromRunnable(() -> this.setValue(null)));
            this.reload();
        }
    }
}

