/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import java.nio.charset.Charset;
import org.jetlinks.supports.protocol.codec.BinaryCodec;

public class StringCodec
implements BinaryCodec<String> {
    private final Charset charset;
    private final int offset;
    private final int length;

    @Override
    public String decode(byte[] payload, int offset) {
        offset = this.offset + offset;
        int readableLength = payload.length - offset;
        if (this.length != -1) {
            readableLength = Math.min(readableLength, this.length);
        }
        return new String(payload, offset, readableLength);
    }

    @Override
    public void encode(String part, byte[] payload, int offset) {
        byte[] data = part.getBytes(this.charset);
        System.arraycopy(data, 0, payload, this.offset + offset, data.length);
    }

    private StringCodec(Charset charset, int offset, int length) {
        this.charset = charset;
        this.offset = offset;
        this.length = length;
    }

    public static StringCodec of(Charset charset, int offset, int length) {
        return new StringCodec(charset, offset, length);
    }
}

