/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.cluster.ClusterTopic;
import org.jetlinks.supports.cluster.AbstractLocalCache;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClusterLocalCache<K, V>
extends AbstractLocalCache<K, V> {
    private final ClusterTopic<K> clearTopic;

    public ClusterLocalCache(String name, ClusterManager clusterManager) {
        this(name, clusterManager, clusterManager.createCache(name), CacheBuilder.newBuilder().build());
    }

    public ClusterLocalCache(String name, ClusterManager clusterManager, ClusterCache<K, V> clusterCache, Cache<K, Object> localCache) {
        super(clusterCache, localCache);
        this.clearTopic = clusterManager.getTopic("_local_cache_modify:".concat(name));
    }

    @Override
    protected Mono<Void> onUpdate(K key, V value) {
        return this.clearTopic.publish((Publisher)Mono.just(key)).then();
    }

    @Override
    protected Mono<Void> onRemove(K key) {
        return this.clearTopic.publish((Publisher)Mono.just(key)).then();
    }

    @Override
    protected Mono<Void> onRemove(Collection<? extends K> key) {
        return this.clearTopic.publish((Publisher)Flux.fromIterable(key)).then();
    }

    @Override
    protected Mono<Void> onClear() {
        return this.clearTopic.publish((Publisher)Mono.just((Object)"__all")).then();
    }
}

