/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.supports.official.JetLinksPropertyMetadata;
import org.springframework.core.ResolvableType;
import org.springframework.util.ReflectionUtils;
import reactor.util.function.Tuples;

public class DeviceMetadataParser {
    Set<Object> distinct = new HashSet<Object>();

    private DeviceMetadataParser() {
    }

    public static PropertyMetadata withField(Field field, ResolvableType type) {
        return new DeviceMetadataParser().withField0(null, field, type);
    }

    public static DataType withType(ResolvableType type) {
        return new DeviceMetadataParser().withType0(null, type);
    }

    private PropertyMetadata withField0(Object owner, Field field, ResolvableType type) {
        Schema schema = field.getAnnotation(Schema.class);
        String id = field.getName();
        String name = schema == null ? field.getName() : schema.description();
        JetLinksPropertyMetadata metadata = new JetLinksPropertyMetadata();
        metadata.setId(id);
        metadata.setName(name);
        metadata.setDataType(this.withType0(field, type));
        return metadata;
    }

    private DataType withType0(Object owner, ResolvableType type) {
        Class clazz = type.toClass();
        if (clazz == Object.class) {
            return null;
        }
        if (List.class.isAssignableFrom(clazz)) {
            ArrayType arrayType = new ArrayType();
            arrayType.setElementType(this.withType0(owner, type.getGeneric(new int[]{0})));
            return arrayType;
        }
        if (clazz.isArray()) {
            ArrayType arrayType = new ArrayType();
            arrayType.setElementType(this.withType0(owner, ResolvableType.forType(clazz.getComponentType())));
            return arrayType;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new ObjectType();
        }
        if (clazz == String.class || clazz == Character.class) {
            return new StringType();
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new IntType().max((Number)127);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new IntType().max((Number)Short.MAX_VALUE).min((Number)0);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new IntType();
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new LongType();
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new FloatType();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new DoubleType();
        }
        if (clazz == Date.class || clazz == LocalDateTime.class) {
            return new DateTimeType();
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new BooleanType();
        }
        if (clazz.isEnum()) {
            EnumType enumType = new EnumType();
            for (Object constant : clazz.getEnumConstants()) {
                Object dict;
                if (constant instanceof EnumDict) {
                    dict = (EnumDict)constant;
                    enumType.addElement(EnumType.Element.of((String)String.valueOf(dict.getValue()), (String)dict.getText()));
                    continue;
                }
                dict = (Enum)constant;
                enumType.addElement(EnumType.Element.of((String)((Enum)dict).name(), (String)((Enum)dict).name()));
            }
            return enumType;
        }
        ObjectType objectType = new ObjectType();
        ReflectionUtils.doWithFields((Class)type.toClass(), field -> {
            if (owner != null && !this.distinct.add(Tuples.of((Object)owner, (Object)field))) {
                objectType.addPropertyMetadata(this.withField0(type.toClass(), field, ResolvableType.forClass(Map.class)));
                return;
            }
            Schema schema = field.getAnnotation(Schema.class);
            if (schema != null && !schema.hidden()) {
                objectType.addPropertyMetadata(this.withField0(type.toClass(), field, ResolvableType.forField((Field)field, (ResolvableType)type)));
            }
        });
        return objectType;
    }
}

