/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import org.jetlinks.supports.protocol.codec.BinaryCodec;
import org.jetlinks.supports.protocol.codec.Endian;

public class TwoBytesFloatCodec
implements BinaryCodec<Float> {
    private final Endian endian;
    private final int offset;

    @Override
    public Float decode(byte[] payload, int offset) {
        byte high = payload[offset + this.offset];
        byte low = payload[offset + this.offset + 1];
        if (this.endian == Endian.Little) {
            byte tmp = low;
            low = high;
            high = tmp;
        }
        return Float.valueOf((float)high + (low == 0 ? 0.0f : (float)((double)low / Math.pow(10.0, (int)Math.log10(low) + 1))));
    }

    @Override
    public void encode(Float part, byte[] payload, int offset) {
        int high = (int)Math.floor(part.floatValue());
        int low = Math.round((part.floatValue() - (float)high) * 100.0f);
        if (this.endian == Endian.Little) {
            payload[offset + this.offset] = (byte)low;
            payload[offset + this.offset + 1] = (byte)high;
        } else {
            payload[offset + this.offset] = (byte)high;
            payload[offset + this.offset + 1] = (byte)low;
        }
    }

    private TwoBytesFloatCodec(Endian endian, int offset) {
        this.endian = endian;
        this.offset = offset;
    }

    public static TwoBytesFloatCodec of(Endian endian, int offset) {
        return new TwoBytesFloatCodec(endian, offset);
    }
}

