/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.scalecube;

import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.cluster.load.LoadBalancer;
import org.jetlinks.core.cluster.load.LoadSupplier;
import org.jetlinks.core.cluster.load.ServerLoad;
import org.jetlinks.core.rpc.RpcManager;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClusterLoadBalancer
implements LoadBalancer {
    private final RpcManager rpcManager;
    private final Map<String, LoadSupplier> suppliers = new ConcurrentHashMap<String, LoadSupplier>();
    private final Disposable.Composite disposable = Disposables.composite();

    public void init() {
        this.disposable.add(this.rpcManager.registerService((Object)new LoadBalancerServiceImpl(this)));
    }

    public Disposable register(LoadSupplier loadSupplier) {
        this.suppliers.put(loadSupplier.loadId(), loadSupplier);
        loadSupplier.init((LoadBalancer)this);
        return () -> this.suppliers.remove(loadSupplier.loadId(), loadSupplier);
    }

    public Flux<ServerLoad> loads() {
        return this.rpcManager.getServices(LoadBalancerService.class).flatMap(service -> ((LoadBalancerService)service.service()).loads());
    }

    public Mono<ServerLoad> load(String serviceNodeId, String featureId) {
        return this.rpcManager.getService(serviceNodeId, LoadBalancerService.class).flatMap(service -> service.load(featureId));
    }

    public Flux<ServerLoad> loads(String serviceNodeId) {
        return this.rpcManager.getService(serviceNodeId, LoadBalancerService.class).flatMapMany(LoadBalancerService::loads);
    }

    public Flux<ServerLoad> localLoads() {
        return Flux.fromIterable(this.suppliers.values()).flatMap(this::getLoad);
    }

    public Mono<ServerLoad> localLoad(String featureId) {
        LoadSupplier supplier = this.suppliers.get(featureId);
        if (null != supplier) {
            return this.getLoad(supplier);
        }
        return Mono.empty();
    }

    private Mono<ServerLoad> getLoad(LoadSupplier supplier) {
        return supplier.currentLoad().map(load -> ServerLoad.of((String)this.currentServiceId(), (String)supplier.loadId(), (long)load));
    }

    public String currentServiceId() {
        return this.rpcManager.currentServerId();
    }

    public ClusterLoadBalancer(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    static class LoadBalancerServiceImpl
    implements LoadBalancerService {
        private final LoadBalancer loadBalancer;

        @Override
        public Flux<ServerLoad> loads() {
            return this.loadBalancer.localLoads();
        }

        @Override
        public Mono<ServerLoad> load(String featureId) {
            return this.loadBalancer.localLoad(featureId);
        }

        public LoadBalancerServiceImpl(LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
        }
    }

    @Service
    public static interface LoadBalancerService {
        @ServiceMethod
        public Flux<ServerLoad> loads();

        @ServiceMethod
        public Mono<ServerLoad> load(String var1);
    }
}

