/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.scalecube.rpc;

import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceInfo;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.PrincipalMapper;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodInvoker;
import io.scalecube.services.methods.ServiceMethodRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.supports.scalecube.rpc.ScalecubeRpcManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcServiceMethodRegistry
implements ServiceMethodRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMethodRegistry.class);
    private final List<ServiceInfo> serviceInfos = new CopyOnWriteArrayList<ServiceInfo>();
    private final ConcurrentMap<String, ServiceMethodInvoker> methodInvokers = new ConcurrentHashMap<String, ServiceMethodInvoker>();

    RpcServiceMethodRegistry() {
    }

    public void registerService(ServiceInfo serviceInfo) {
        this.serviceInfos.add(serviceInfo);
        String serviceId = serviceInfo.tags().getOrDefault("_sid", "_default");
        Reflect.serviceInterfaces((Object)serviceInfo.serviceInstance()).forEach(serviceInterface -> Reflect.serviceMethods((Class)serviceInterface).forEach((key, method) -> {
            Reflect.validateMethodOrThrow((Method)method);
            String serviceName = ScalecubeRpcManager.createMethodQualifier(serviceId, Reflect.serviceName((Class)serviceInterface));
            MethodInfo methodInfo = new MethodInfo(serviceName, Reflect.methodName((Method)method), Reflect.parameterizedReturnType((Method)method), Reflect.isReturnTypeServiceMessage((Method)method), Reflect.communicationMode((Method)method), method.getParameterCount(), Reflect.requestType((Method)method), Reflect.isRequestTypeServiceMessage((Method)method), Reflect.isSecured((Method)method));
            this.checkMethodInvokerDoesntExist(methodInfo);
            ServiceMethodInvoker methodInvoker = new ServiceMethodInvoker((Method)method, serviceInfo.serviceInstance(), methodInfo, serviceInfo.errorMapper(), serviceInfo.dataDecoder(), (Authenticator<Object>)serviceInfo.authenticator(), (PrincipalMapper<Object, Object>)serviceInfo.principalMapper());
            this.methodInvokers.put(methodInfo.qualifier(), methodInvoker);
            this.methodInvokers.put(methodInfo.oldQualifier(), methodInvoker);
        }));
    }

    private void checkMethodInvokerDoesntExist(MethodInfo methodInfo) {
        if (this.methodInvokers.containsKey(methodInfo.qualifier()) || this.methodInvokers.containsKey(methodInfo.oldQualifier())) {
            LOGGER.error("MethodInvoker already exists, methodInfo: {}", (Object)methodInfo);
            throw new IllegalStateException("MethodInvoker already exists");
        }
    }

    public ServiceMethodInvoker getInvoker(String qualifier) {
        return (ServiceMethodInvoker)this.methodInvokers.get(Objects.requireNonNull(qualifier, "[getInvoker] qualifier"));
    }

    public List<ServiceMethodInvoker> listInvokers() {
        return new ArrayList<ServiceMethodInvoker>(this.methodInvokers.values());
    }

    public List<ServiceInfo> listServices() {
        return new ArrayList<ServiceInfo>(this.serviceInfos);
    }
}

