/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.auth.Authenticator;
import io.scalecube.services.auth.PrincipalMapper;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ServiceException;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.exceptions.UnauthorizedException;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.transport.api.ServiceMessageDataDecoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.jetlinks.core.trace.TraceHolder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public final class ServiceMethodInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMethodInvoker.class);
    private final Method method;
    private final Object service;
    private final MethodInfo methodInfo;
    private final ServiceProviderErrorMapper errorMapper;
    private final ServiceMessageDataDecoder dataDecoder;
    private final Authenticator<Object> authenticator;
    private final PrincipalMapper<Object, Object> principalMapper;

    public ServiceMethodInvoker(Method method, Object service, MethodInfo methodInfo, ServiceProviderErrorMapper errorMapper, ServiceMessageDataDecoder dataDecoder, Authenticator<Object> authenticator, PrincipalMapper<Object, Object> principalMapper) {
        this.method = Objects.requireNonNull(method, "method");
        this.service = Objects.requireNonNull(service, "service");
        this.methodInfo = Objects.requireNonNull(methodInfo, "methodInfo");
        this.errorMapper = Objects.requireNonNull(errorMapper, "errorMapper");
        this.dataDecoder = Objects.requireNonNull(dataDecoder, "dataDecoder");
        this.authenticator = authenticator;
        this.principalMapper = principalMapper;
    }

    public Mono<ServiceMessage> invokeOne(ServiceMessage message) {
        return Mono.deferContextual(context -> this.authenticate(message, (ContextView)context)).flatMap(authData -> this.deferWithContextOne(message, authData)).map(response -> this.toResponse(response, message.qualifier(), message.dataFormat())).onErrorResume(throwable -> Mono.just((Object)this.errorMapper.toMessage(message.qualifier(), throwable)));
    }

    public Flux<ServiceMessage> invokeMany(ServiceMessage message) {
        return Mono.deferContextual(context -> this.authenticate(message, (ContextView)context)).flatMapMany(authData -> this.deferWithContextMany(message, authData)).map(response -> this.toResponse(response, message.qualifier(), message.dataFormat())).onErrorResume(throwable -> Flux.just((Object)this.errorMapper.toMessage(message.qualifier(), throwable)));
    }

    public Flux<ServiceMessage> invokeBidirectional(Publisher<ServiceMessage> publisher) {
        return Flux.deferContextual(ctx -> Flux.from((Publisher)publisher).switchOnFirst((s, flux) -> {
            ServiceMessage first;
            if (s.hasValue() && (first = (ServiceMessage)s.get()) != null) {
                return this.authenticate(first, (ContextView)ctx).flatMapMany(authData -> flux.map(this::toRequest).transform(this::invoke).contextWrite(context -> this.enhanceContext(authData, (Context)context))).contextWrite((ContextView)TraceHolder.readToContext((ContextView)s.getContextView(), (Map)first.headers())).map(response -> this.toResponse(response, first.qualifier(), first.dataFormat())).onErrorResume(throwable -> Flux.just((Object)this.errorMapper.toMessage(first.qualifier(), throwable)));
            }
            return flux.then(Mono.empty());
        }));
    }

    private Mono<?> deferWithContextOne(ServiceMessage message, Object authData) {
        return Mono.from(this.invoke(this.toRequest(message))).contextWrite(context -> TraceHolder.readToContext((ContextView)this.enhanceContext(authData, (Context)context), (Map)message.headers()));
    }

    private Flux<?> deferWithContextMany(ServiceMessage message, Object authData) {
        return Flux.from(this.invoke(this.toRequest(message))).contextWrite(context -> TraceHolder.readToContext((ContextView)this.enhanceContext(authData, (Context)context), (Map)message.headers()));
    }

    private Flux<?> deferWithContextBidirectional(Flux<ServiceMessage> messages, Object authData) {
        return messages.switchOnFirst((s, flux) -> {
            ServiceMessage msg;
            if (s.hasValue() && (msg = (ServiceMessage)s.get()) != null) {
                return flux.map(this::toRequest).transform(this::invoke).contextWrite((ContextView)TraceHolder.readToContext((ContextView)s.getContextView(), (Map)msg.headers()));
            }
            return flux;
        }).contextWrite(context -> this.enhanceContext(authData, (Context)context));
    }

    private Publisher<?> invoke(Object request) {
        Mono result = null;
        Throwable throwable = null;
        try {
            if (this.methodInfo.parameterCount() == 0) {
                result = (Publisher)this.method.invoke(this.service, new Object[0]);
            } else {
                Object[] arguments = this.prepareArguments(request);
                result = (Publisher)this.method.invoke(this.service, arguments);
            }
            if (result == null) {
                result = Mono.empty();
            }
        }
        catch (InvocationTargetException ex) {
            throwable = Optional.ofNullable(ex.getCause()).orElse(ex);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        return throwable != null ? Mono.error((Throwable)throwable) : result;
    }

    private Object[] prepareArguments(Object request) {
        Object[] arguments = new Object[this.methodInfo.parameterCount()];
        if (this.methodInfo.requestType() != Void.TYPE) {
            arguments[0] = request;
        }
        return arguments;
    }

    private Mono<Object> authenticate(ServiceMessage message, ContextView context) {
        if (!this.methodInfo.isSecured()) {
            return Mono.just((Object)Authenticator.NULL_AUTH_CONTEXT);
        }
        if (this.authenticator == null) {
            if (context.hasKey((Object)"auth.context")) {
                return Mono.just((Object)context.get((Object)"auth.context"));
            }
            LOGGER.error("Authentication failed (auth context not found and authenticator not set)");
            throw new UnauthorizedException("Authentication failed");
        }
        return ((Mono)this.authenticator.apply((Object)message.headers())).switchIfEmpty(Mono.just((Object)Authenticator.NULL_AUTH_CONTEXT)).onErrorMap(this::toUnauthorizedException);
    }

    private UnauthorizedException toUnauthorizedException(Throwable th) {
        if (th instanceof ServiceException) {
            ServiceException e = (ServiceException)th;
            return new UnauthorizedException(e.errorCode(), e.getMessage());
        }
        return new UnauthorizedException(th);
    }

    private Context enhanceContext(Object authData, Context context) {
        if (authData == Authenticator.NULL_AUTH_CONTEXT || this.principalMapper == null) {
            return context.put((Object)"auth.context", authData);
        }
        Object mappedData = this.principalMapper.apply(authData);
        return context.put((Object)"auth.context", mappedData != null ? mappedData : Authenticator.NULL_AUTH_CONTEXT);
    }

    private Object toRequest(ServiceMessage message) {
        ServiceMessage request = (ServiceMessage)this.dataDecoder.apply((Object)message, (Object)this.methodInfo.requestType());
        if (!(this.methodInfo.isRequestTypeVoid() || this.methodInfo.isRequestTypeServiceMessage() || request.hasData(this.methodInfo.requestType()))) {
            Optional<Object> dataOptional = Optional.ofNullable(request.data());
            Class clazz = dataOptional.map(Object::getClass).orElse(null);
            throw new BadRequestException(String.format("Expected service request data of type: %s, but received: %s", this.methodInfo.requestType(), clazz));
        }
        return this.methodInfo.isRequestTypeServiceMessage() ? request : request.data();
    }

    private ServiceMessage toResponse(Object response, String qualifier, String dataFormat) {
        if (response instanceof ServiceMessage) {
            ServiceMessage message = (ServiceMessage)response;
            if (dataFormat != null && !dataFormat.equals(message.dataFormat())) {
                return ServiceMessage.from((ServiceMessage)message).qualifier(qualifier).dataFormat(dataFormat).build();
            }
            return ServiceMessage.from((ServiceMessage)message).qualifier(qualifier).build();
        }
        return ServiceMessage.builder().qualifier(qualifier).data(response).dataFormatIfAbsent(dataFormat).build();
    }

    public Object service() {
        return this.service;
    }

    public MethodInfo methodInfo() {
        return this.methodInfo;
    }

    public String toString() {
        return new StringJoiner(", ", ServiceMethodInvoker.class.getSimpleName() + "[", "]").add("method=" + this.method).add("service=" + this.service).add("methodInfo=" + this.methodInfo).add("errorMapper=" + this.errorMapper).add("dataDecoder=" + this.dataDecoder).add("authenticator=" + this.authenticator).add("principalMapper=" + this.principalMapper).toString();
    }
}

