/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.command;

import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.annotation.Attr;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.AbstractCommandSupport;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandConstant;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandMetadataResolver;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.utils.MetadataUtils;
import org.jetlinks.supports.official.DeviceMetadataParser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MethodInvocationException;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JavaBeanCommandSupport
extends AbstractCommandSupport {
    private static final Logger log = LoggerFactory.getLogger(JavaBeanCommandSupport.class);
    private static final Predicate<Method> defaultFilter = method -> {
        org.jetlinks.core.annotation.command.CommandHandler annotation = (org.jetlinks.core.annotation.command.CommandHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class);
        return !Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getDeclaringClass() != Object.class && (annotation == null || !annotation.ignore());
    };
    protected final Object target;
    private static final MetadataHandler DO_NOTHING_HANDLER = (cmd, metadata) -> Mono.just((Object)metadata);

    public JavaBeanCommandSupport(Object target, Collection<String> filter) {
        this(target, (Method m) -> filter.contains(m.getName()));
    }

    public JavaBeanCommandSupport(Object target, Predicate<Method> filter) {
        this.target = target;
        this.init(defaultFilter.and(filter));
    }

    public JavaBeanCommandSupport(Object target) {
        this(target, (Method method) -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class) != null);
    }

    private void init(Predicate<Method> filter) {
        Class clazz = ClassUtils.getUserClass((Object)this.target);
        ReflectionUtils.doWithMethods((Class)clazz, method -> {
            if (filter.test(method)) {
                this.register(method, clazz);
            }
        });
    }

    private boolean returnIsVoid(ResolvableType type) {
        if (type.getGenerics().length > 0) {
            return this.returnIsVoid(type.getGeneric(new int[]{0}));
        }
        return type.toClass() == Void.class || type.toClass() == Void.TYPE;
    }

    private static Object doInvoke(Object target, Method method, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (MethodInvocationException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public List<CommandHandler<Command<?>, ?>> getHandlers() {
        return this.handlers.values().stream().distinct().collect(Collectors.toList());
    }

    private void register(Method method, Class<?> owner) {
        String id;
        Schema schema = (Schema)AnnotationUtils.findAnnotation((Method)method, Schema.class);
        Object target = this.target;
        String name = id = schema != null && StringUtils.hasText((String)schema.name()) ? schema.name() : method.getName();
        String description = id;
        MethodDesc desc = new MethodDesc(owner, method);
        ResolvableType returnType = ResolvableType.forMethodReturnType((Method)method, owner);
        DataType output = null;
        MethodInvoker invoker = null;
        Parameter[] parameters = desc.parameters;
        String[] argNames = desc.argNames;
        List<SimplePropertyMetadata> inputs = new ArrayList();
        ResolvableType[] argTypes = desc.argTypes;
        if (!this.returnIsVoid(returnType)) {
            output = DeviceMetadataParser.withType(returnType);
        }
        if (argTypes.length == 0) {
            invoker = ignore -> JavaBeanCommandSupport.doInvoke(target, method, new Object[0]);
        } else {
            if (argTypes.length == 1) {
                if (Command.class.isAssignableFrom(argTypes[0].toClass())) {
                    invoker = new CommandInvoker(target, method, argTypes[0]);
                    FunctionMetadata resolve = CommandMetadataResolver.resolve((ResolvableType)desc.argTypes[0], (ResolvableType)ResolvableType.NONE);
                    id = resolve.getId();
                    name = resolve.getName();
                    description = resolve.getDescription();
                    inputs = resolve.getInputs();
                } else {
                    RequestBody requestBody = (RequestBody)AnnotationUtils.findAnnotation((AnnotatedElement)method.getParameters()[0], RequestBody.class);
                    if (requestBody != null) {
                        DataType metadataType = DeviceMetadataParser.withType(argTypes[0]);
                        if (metadataType instanceof ObjectType) {
                            inputs = ((ObjectType)metadataType).getProperties();
                        }
                        Class type = argTypes[0].toClass();
                        invoker = cmd -> {
                            Object param = cmd.as(type);
                            return JavaBeanCommandSupport.doInvoke(target, method, param);
                        };
                    }
                }
            }
            if (invoker == null) {
                for (int i = 0; i < argTypes.length; ++i) {
                    ResolvableType type = argTypes[i];
                    Parameter parameter = parameters[i];
                    Schema schemaAnn = parameter.getAnnotation(Schema.class);
                    DataType dataType = DeviceMetadataParser.withType(type);
                    SimplePropertyMetadata metadata = new SimplePropertyMetadata();
                    metadata.setId(argNames[i]);
                    metadata.setDescription(schemaAnn == null ? null : schemaAnn.description());
                    metadata.setName(schemaAnn != null && StringUtils.hasText((String)schemaAnn.title()) ? schemaAnn.title() : metadata.getId());
                    metadata.setValueType(dataType);
                    MetadataUtils.parseExpands((Annotation[])parameter.getAnnotations()).forEach((arg_0, arg_1) -> ((SimplePropertyMetadata)metadata).expand(arg_0, arg_1));
                    inputs.add(metadata);
                }
                invoker = cmd -> {
                    Object[] args = new Object[argTypes.length];
                    for (int i = 0; i < argTypes.length; ++i) {
                        ResolvableType type = argTypes[i];
                        args[i] = cmd.getOrNull(argNames[i], type.getType());
                    }
                    return JavaBeanCommandSupport.doInvoke(target, method, args);
                };
            }
        }
        SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
        metadata.setId(id);
        metadata.setOutput(output);
        metadata.setInputs(inputs);
        metadata.setName(schema != null && StringUtils.hasText((String)schema.title()) ? schema.title() : name);
        metadata.setDescription(schema != null && StringUtils.hasText((String)schema.description()) ? schema.description() : description);
        MethodCallCommandHandler handler = new MethodCallCommandHandler(invoker, this.applyMetadata(method, argTypes, metadata), this.createMetadataHandler(owner, method), method);
        this.registerHandlerAbsent(metadata.getId(), handler);
    }

    protected <C extends Command<R>, R> void registerHandlerAbsent(String id, CommandHandler<C, R> handler) {
        this.handlers.computeIfAbsent(id, k -> handler);
    }

    private MetadataHandler createMetadataHandler(Class<?> owner, Method method) {
        org.jetlinks.core.annotation.command.CommandHandler annotation = (org.jetlinks.core.annotation.command.CommandHandler)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class);
        if (annotation == null || !StringUtils.hasText((String)annotation.outputProvider())) {
            return DO_NOTHING_HANDLER;
        }
        String provider = annotation.outputProvider();
        Method providerMethod = ReflectionUtils.findMethod((Class)ClassUtils.getUserClass((Object)this.target), (String)provider, (Class[])null);
        if (providerMethod == null) {
            log.warn("outputProvider method [{}] not found for {}", (Object)provider, (Object)providerMethod);
            return DO_NOTHING_HANDLER;
        }
        MethodDesc desc = new MethodDesc(owner, providerMethod);
        ResolvableType returnType = desc.returnType;
        if (!DataType.class.isAssignableFrom(CommandUtils.getCommandResponseDataType((ResolvableType)returnType).toClass())) {
            log.warn("outputProvider method [{}] return type not DataType for {}", (Object)provider, (Object)method);
            return DO_NOTHING_HANDLER;
        }
        return new DefaultMetadataHandler(desc.createMethodInvoker());
    }

    protected SimpleFunctionMetadata applyMetadata(Method method, ResolvableType[] argTypes, SimpleFunctionMetadata metadata) {
        org.jetlinks.core.annotation.command.CommandHandler annotation = (org.jetlinks.core.annotation.command.CommandHandler)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class);
        if (annotation == null) {
            return metadata;
        }
        if (annotation.value() != Command.class) {
            FunctionMetadata resolve = CommandMetadataResolver.resolve((Class)annotation.value(), Object.class);
            metadata.setId(resolve.getId());
            metadata.setName(resolve.getName());
            metadata.setDescription(resolve.getDescription());
            metadata.setInputs(resolve.getInputs());
        }
        if (StringUtils.hasText((String)annotation.id())) {
            metadata.setId(annotation.id());
        }
        if (StringUtils.hasText((String)annotation.name())) {
            metadata.setName(LocaleUtils.resolveMessage((String)annotation.name(), (String)annotation.name(), (Object[])new Object[0]));
        }
        if (StringUtils.hasText((String)annotation.description())) {
            metadata.setDescription(annotation.description());
        }
        metadata.setExpands(MetadataUtils.parseExpands((AnnotatedElement)method));
        MetadataUtils.resolveAttrs((Attr[])annotation.expands(), (arg_0, arg_1) -> ((SimpleFunctionMetadata)metadata).expand(arg_0, arg_1));
        metadata.expand(CommandConstant.responseFlux, (Object)Flux.class.isAssignableFrom(method.getReturnType()));
        if (!Void.class.equals((Object)annotation.inputSpec())) {
            metadata.setInputs(CommandMetadataResolver.resolveInputs((ResolvableType)ResolvableType.forType((Type)annotation.inputSpec())));
        }
        if (!Void.class.equals((Object)annotation.outputSpec())) {
            metadata.setOutput(CommandMetadataResolver.resolveOutput((ResolvableType)ResolvableType.forType((Type)annotation.outputSpec())));
        }
        return metadata;
    }

    public String toString() {
        return this.handlers.values().toString();
    }

    public static class MethodCallCommand
    extends AbstractCommand<Object, MethodCallCommand> {
        private String commandId;

        public String getCommandId() {
            return this.commandId;
        }

        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public MethodCallCommand(String commandId) {
            this.commandId = commandId;
        }

        public MethodCallCommand() {
        }
    }

    public static class MethodCallFluxCommand
    extends AbstractCommand<Flux<Object>, MethodCallFluxCommand> {
        private String commandId;

        public String getCommandId() {
            return this.commandId;
        }

        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public MethodCallFluxCommand(String commandId) {
            this.commandId = commandId;
        }

        public MethodCallFluxCommand() {
        }
    }

    static class MethodCallCommandHandler
    implements CommandHandler<Command<Object>, Object> {
        private final MethodInvoker invoker;
        private final SimpleFunctionMetadata metadata;
        private final MetadataHandler metadataHandler;
        private final Method method;

        public Object handle(@Nonnull Command<Object> command, @Nonnull CommandSupport support) {
            return this.invoker.apply(command);
        }

        public Mono<FunctionMetadata> getMetadata(Command<?> cmd) {
            return this.metadataHandler.apply(cmd, this.metadata);
        }

        @Nonnull
        public Command<Object> createCommand() {
            if (this.metadata.getExpand(CommandConstant.responseFlux).orElse(false).booleanValue()) {
                return new MethodCallFluxCommand(this.metadata.getId());
            }
            return new MethodCallCommand(this.metadata.getId());
        }

        public FunctionMetadata getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return String.valueOf(this.method);
        }

        public MethodCallCommandHandler(MethodInvoker invoker, SimpleFunctionMetadata metadata, MetadataHandler metadataHandler, Method method) {
            this.invoker = invoker;
            this.metadata = metadata;
            this.metadataHandler = metadataHandler;
            this.method = method;
        }
    }

    static class CommandInvoker
    implements MethodInvoker {
        private final Object target;
        private final Method method;
        private final ResolvableType type;

        @Override
        public Object apply(Command<Object> objectCommand) {
            if (this.type.toClass().isInstance(objectCommand)) {
                return JavaBeanCommandSupport.doInvoke(this.target, this.method, new Object[]{objectCommand});
            }
            return JavaBeanCommandSupport.doInvoke(this.target, this.method, new Object[]{this.createCommand().with(objectCommand.asMap())});
        }

        private Command<Object> createCommand() {
            Command cmd = (Command)this.type.toClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return cmd;
        }

        public CommandInvoker(Object target, Method method, ResolvableType type) {
            this.target = target;
            this.method = method;
            this.type = type;
        }
    }

    static interface MetadataHandler
    extends BiFunction<Command<?>, SimpleFunctionMetadata, Mono<FunctionMetadata>> {
        @Override
        public Mono<FunctionMetadata> apply(Command<?> var1, SimpleFunctionMetadata var2);
    }

    static interface MethodInvoker
    extends Function<Command<Object>, Object> {
    }

    private static class DefaultMetadataHandler
    implements MetadataHandler {
        private final MethodInvoker invoker;

        private Mono<FunctionMetadata> convertMetadata(Object data, SimpleFunctionMetadata metadata) {
            if (data instanceof DataType) {
                metadata = metadata.copy();
                metadata.setOutput((DataType)data);
            }
            return Mono.just((Object)metadata);
        }

        @Override
        public Mono<FunctionMetadata> apply(Command<?> objectCommand, SimpleFunctionMetadata metadata) {
            Object object = this.invoker.apply(objectCommand);
            if (object instanceof Publisher) {
                return Mono.from((Publisher)((Publisher)object)).flatMap(data -> this.convertMetadata(data, metadata));
            }
            return this.convertMetadata(object, metadata);
        }

        public DefaultMetadataHandler(MethodInvoker invoker) {
            this.invoker = invoker;
        }
    }

    private class MethodDesc {
        final ResolvableType[] argTypes;
        final String[] argNames;
        final Method method;
        final ResolvableType returnType;
        final Parameter[] parameters;

        public MethodDesc(Class<?> owner, Method method) {
            this.method = method;
            this.argTypes = new ResolvableType[method.getParameterCount()];
            this.argNames = new String[method.getParameterCount()];
            this.parameters = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                this.argTypes[i] = ResolvableType.forMethodParameter((Method)method, (int)i, owner);
            }
            String[] discoveredArgName = MethodInterceptorHolder.nameDiscoverer.getParameterNames(method);
            for (int i = 0; i < this.argNames.length; ++i) {
                Parameter parameter = this.parameters[i];
                Schema schemaAnn = parameter.getAnnotation(Schema.class);
                this.argNames[i] = schemaAnn != null && StringUtils.hasText((String)schemaAnn.name()) ? schemaAnn.name() : (discoveredArgName != null && discoveredArgName.length > i ? discoveredArgName[i] : "arg" + i);
            }
            this.returnType = ResolvableType.forMethodReturnType((Method)method, owner);
        }

        public MethodInvoker createMethodInvoker() {
            ResolvableType[] argTypes = this.argTypes;
            String[] argNames = this.argNames;
            Method method = this.method;
            ReflectionUtils.makeAccessible((Method)method);
            if (argTypes.length == 0) {
                return ignore -> JavaBeanCommandSupport.doInvoke(JavaBeanCommandSupport.this.target, method, new Object[0]);
            }
            if (argTypes.length == 1 && Command.class.isAssignableFrom(argTypes[0].toClass())) {
                return new CommandInvoker(JavaBeanCommandSupport.this.target, method, argTypes[0]);
            }
            RequestBody requestBody = (RequestBody)AnnotationUtils.findAnnotation((AnnotatedElement)this.parameters[0], RequestBody.class);
            if (requestBody != null) {
                Class type = argTypes[0].toClass();
                return cmd -> {
                    Object param = cmd.as(type);
                    return JavaBeanCommandSupport.doInvoke(JavaBeanCommandSupport.this.target, method, new Object[]{param});
                };
            }
            return cmd -> {
                Object[] args = new Object[argTypes.length];
                for (int i = 0; i < argTypes.length; ++i) {
                    ResolvableType type = argTypes[i];
                    args[i] = cmd.getOrNull(argNames[i], type.getType());
                }
                return JavaBeanCommandSupport.doInvoke(JavaBeanCommandSupport.this.target, method, args);
            };
        }
    }
}

