/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DataTypeCodec;
import org.jetlinks.supports.official.types.JetLinksArrayCodec;
import org.jetlinks.supports.official.types.JetLinksBooleanCodec;
import org.jetlinks.supports.official.types.JetLinksByteCodec;
import org.jetlinks.supports.official.types.JetLinksDateCodec;
import org.jetlinks.supports.official.types.JetLinksDoubleCodec;
import org.jetlinks.supports.official.types.JetLinksEnumCodec;
import org.jetlinks.supports.official.types.JetLinksFileCodec;
import org.jetlinks.supports.official.types.JetLinksFloatCodec;
import org.jetlinks.supports.official.types.JetLinksGeoPointCodec;
import org.jetlinks.supports.official.types.JetLinksGeoShapeCodec;
import org.jetlinks.supports.official.types.JetLinksIntCodec;
import org.jetlinks.supports.official.types.JetLinksLongCodec;
import org.jetlinks.supports.official.types.JetLinksObjectCodec;
import org.jetlinks.supports.official.types.JetLinksPasswordCodec;
import org.jetlinks.supports.official.types.JetLinksShortCodec;
import org.jetlinks.supports.official.types.JetLinksStringCodec;
import org.jetlinks.supports.official.types.JetLinksUserCodec;

public class JetLinksDataTypeCodecs {
    private static final Map<String, DataTypeCodec<? extends DataType>> codecMap = new ConcurrentHashMap<String, DataTypeCodec<? extends DataType>>();

    private JetLinksDataTypeCodecs() {
    }

    public static void register(DataTypeCodec<? extends DataType> codec) {
        codecMap.put(codec.getTypeId(), codec);
    }

    public static Optional<DataTypeCodec<DataType>> getCodec(String typeId) {
        return Optional.ofNullable(codecMap.get(typeId));
    }

    public static DataType decode(DataType type, Map<String, Object> config) {
        if (type == null) {
            return null;
        }
        return JetLinksDataTypeCodecs.getCodec(type.getId()).map(codec -> codec.decode(type, config)).orElse(type);
    }

    public static Optional<Map<String, Object>> encode(DataType type) {
        if (type == null) {
            return Optional.empty();
        }
        return JetLinksDataTypeCodecs.getCodec(type.getId()).map(codec -> codec.encode(type));
    }

    static {
        JetLinksDataTypeCodecs.register(new JetLinksArrayCodec());
        JetLinksDataTypeCodecs.register(new JetLinksBooleanCodec());
        JetLinksDataTypeCodecs.register(new JetLinksDateCodec());
        JetLinksDataTypeCodecs.register(new JetLinksDoubleCodec());
        JetLinksDataTypeCodecs.register(new JetLinksEnumCodec());
        JetLinksDataTypeCodecs.register(new JetLinksFloatCodec());
        JetLinksDataTypeCodecs.register(new JetLinksGeoPointCodec());
        JetLinksDataTypeCodecs.register(new JetLinksIntCodec());
        JetLinksDataTypeCodecs.register(new JetLinksLongCodec());
        JetLinksDataTypeCodecs.register(new JetLinksObjectCodec());
        JetLinksDataTypeCodecs.register(new JetLinksStringCodec());
        JetLinksDataTypeCodecs.register(new JetLinksPasswordCodec());
        JetLinksDataTypeCodecs.register(new JetLinksFileCodec());
        JetLinksDataTypeCodecs.register(new JetLinksGeoShapeCodec());
        JetLinksDataTypeCodecs.register(new JetLinksUserCodec());
        JetLinksDataTypeCodecs.register(new JetLinksShortCodec());
        JetLinksDataTypeCodecs.register(new JetLinksByteCodec());
    }
}

