/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol;

import java.util.ServiceLoader;
import lombok.NonNull;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.supports.protocol.StaticProtocolSupports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceLoaderProtocolSupports
implements ProtocolSupports {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderProtocolSupports.class);
    private StaticProtocolSupports supports = new StaticProtocolSupports();
    @NonNull
    private ServiceContext serviceContext;

    public boolean isSupport(String protocol) {
        return this.supports.isSupport(protocol);
    }

    public Mono<ProtocolSupport> getProtocol(String protocol) {
        return this.supports.getProtocol(protocol);
    }

    public Flux<ProtocolSupport> getProtocols() {
        return this.supports.getProtocols();
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void init() {
        ServiceLoader<ProtocolSupportProvider> loader = ServiceLoader.load(ProtocolSupportProvider.class, this.getClassLoader());
        loader.iterator().forEachRemaining(provider -> provider.create(this.serviceContext).doOnNext(pro -> log.debug("found protocol support provider:{}", pro)).subscribe(this.supports::register));
    }

    public void setServiceContext(@NonNull ServiceContext serviceContext) {
        if (serviceContext == null) {
            throw new NullPointerException("serviceContext is marked non-null but is null");
        }
        this.serviceContext = serviceContext;
    }
}

