/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.blocking;

import java.time.Duration;
import javax.annotation.Nullable;
import org.jetlinks.core.defaults.BlockingDeviceOperator;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.FromDeviceMessageContext;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.monitor.Monitor;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.supports.protocol.blocking.BlockingMessageCodecContext;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class BlockingMessageDecodeContext
extends BlockingMessageCodecContext<MessageDecodeContext> {
    public BlockingMessageDecodeContext(Monitor monitor, MessageDecodeContext context, Duration timeout, ContextView ctx) {
        super(monitor, context, timeout, ctx);
    }

    @Override
    @Nullable
    public BlockingDeviceOperator getDevice() {
        return super.getDevice();
    }

    @Override
    @Nullable
    public BlockingDeviceOperator getDevice(String deviceId) {
        return super.getDevice(deviceId);
    }

    public EncodedMessage getData() {
        return ((MessageDecodeContext)this.context).getMessage();
    }

    public DeviceSession getSession() {
        return ((FromDeviceMessageContext)((MessageDecodeContext)this.context).unwrap(FromDeviceMessageContext.class)).getSession();
    }

    public void disconnect() {
        this.getSession().close();
    }

    public void disconnectLater() {
        this.async(Mono.fromRunnable(this::disconnect));
    }

    @Nullable
    public ClientConnection getConnection() {
        return ((FromDeviceMessageContext)((MessageDecodeContext)this.context).unwrap(FromDeviceMessageContext.class)).getConnection();
    }

    public void sendToDeviceNow(EncodedMessage message) {
        this.await(((FromDeviceMessageContext)((MessageDecodeContext)this.context).unwrap(FromDeviceMessageContext.class)).getSession().send(message));
    }

    public void sendToDeviceLater(EncodedMessage message) {
        this.async(((FromDeviceMessageContext)((MessageDecodeContext)this.context).unwrap(FromDeviceMessageContext.class)).getSession().send(message));
    }

    public Mono<Void> sendToDeviceReactive(EncodedMessage message) {
        return ((FromDeviceMessageContext)((MessageDecodeContext)this.context).unwrap(FromDeviceMessageContext.class)).getSession().send(message).then();
    }

    public void sendToPlatformNow(DeviceMessage message) {
        if (message == null) {
            return;
        }
        this.await(((MessageDecodeContext)this.context).handleMessage(message));
    }

    public void sendToPlatformLater(DeviceMessage message) {
        if (message == null) {
            return;
        }
        this.async(((MessageDecodeContext)this.context).handleMessage(message));
    }

    public Mono<Void> sendToPlatformReactive(DeviceMessage message) {
        if (message == null) {
            return Mono.empty();
        }
        return ((MessageDecodeContext)this.context).handleMessage(message);
    }
}

