/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.management.jar;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.ProtocolTracer;
import org.jetlinks.core.utils.ClassUtils;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import org.jetlinks.supports.protocol.management.jar.ProtocolClassLoader;
import org.jetlinks.supports.protocol.validator.MethodDeniedClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JarProtocolSupportLoader
implements ProtocolSupportLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JarProtocolSupportLoader.class);
    private ServiceContext serviceContext;
    private final Map<String, ProtocolClassLoader> protocolLoaders = new ConcurrentHashMap<String, ProtocolClassLoader>();
    private final Map<String, ProtocolSupportProvider> loaded = new ConcurrentHashMap<String, ProtocolSupportProvider>();
    protected final MethodDeniedClassVisitor visitor = MethodDeniedClassVisitor.global();

    @Override
    public String getProvider() {
        return "jar";
    }

    protected ProtocolClassLoader createClassLoader(URL location) {
        return new ProtocolClassLoader(new URL[]{location}, this.getClass().getClassLoader());
    }

    protected void closeAll() {
        this.protocolLoaders.values().forEach(this::closeLoader);
        this.protocolLoaders.clear();
        this.loaded.clear();
    }

    protected void closeLoader(ProtocolClassLoader loader) {
        loader.close();
    }

    protected ServiceContext createServiceContext(ProtocolSupportDefinition definition) {
        return this.serviceContext;
    }

    @Override
    public Mono<? extends ProtocolSupport> load(ProtocolSupportDefinition definition) {
        String id = definition.getId();
        return (Mono)Mono.defer(() -> {
            try {
                Map<String, Object> config = definition.getConfiguration();
                String location = Optional.ofNullable(config.get("location")).map(String::valueOf).orElseThrow(() -> new IllegalArgumentException("location"));
                URL url = !location.contains("://") ? new File(location).toURI().toURL() : new URL("jar:" + location + "!/");
                URL fLocation = url;
                ProtocolSupportProvider oldProvider = this.loaded.remove(id);
                if (null != oldProvider) {
                    oldProvider.dispose();
                }
                ProtocolClassLoader loader = this.protocolLoaders.compute(id, (key, old) -> {
                    if (null != old) {
                        try {
                            this.closeLoader((ProtocolClassLoader)old);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return this.createClassLoader(fLocation);
                });
                log.debug("load protocol support from : {}", (Object)location);
                String provider = Optional.ofNullable(config.get("provider")).map(String::valueOf).map(String::trim).orElse(null);
                ProtocolSupportProvider supportProvider = this.lookupProvider(provider, loader);
                if (null == supportProvider) {
                    return Mono.error((Throwable)new IllegalArgumentException("error.protocol_provider_not_found"));
                }
                ProtocolSupportProvider oldProvider2 = this.loaded.put(id, supportProvider);
                try {
                    if (null != oldProvider2) {
                        oldProvider2.dispose();
                    }
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
                return supportProvider.create(this.createServiceContext(definition));
            }
            catch (Throwable e) {
                return Mono.error((Throwable)e);
            }
        }).subscribeOn(Schedulers.boundedElastic()).as((Function)MonoTracer.create((String)ProtocolTracer.SpanName.install((String)id)));
    }

    protected ProtocolSupportProvider lookupProvider(String provider, ProtocolClassLoader classLoader) {
        ClassUtils.Scanner loaderScanner = ClassUtils.createScanner((ClassLoader)classLoader, (String)"classpath:**/*.class", (boolean)true);
        loaderScanner.walkClass((loader, name, clazz) -> this.visitor.validate((String)name, (InputStream)clazz));
        if (provider != null) {
            Class<?> providerType = classLoader.loadSelfClass(provider);
            return (ProtocolSupportProvider)providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return loaderScanner.findImplClass(ProtocolSupportProvider.class, this::loadProvider).orElse(null);
    }

    protected Class<?> loadProvider(ProtocolClassLoader loader, String className, InputStream classStream) {
        return loader.loadSelfClass(className);
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

