/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cache;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jetlinks.core.utils.Reactors;
import org.slf4j.Logger;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Exceptions;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

public abstract class AsyncLoadCache<T>
extends Mono<T>
implements Disposable {
    private static final AtomicReferenceFieldUpdater<AsyncLoadCache, Object> LOADED = AtomicReferenceFieldUpdater.newUpdater(AsyncLoadCache.class, Object.class, "loaded");
    private static final AtomicReferenceFieldUpdater<AsyncLoadCache, Sinks.One> AWAIT = AtomicReferenceFieldUpdater.newUpdater(AsyncLoadCache.class, Sinks.One.class, "await");
    private final Mono<T> loader;
    private volatile Sinks.One<T> await;
    private final Disposable.Swap loading = Disposables.swap();
    private volatile T loaded;

    public AsyncLoadCache(Mono<T> loader) {
        this.loader = loader;
    }

    @Nullable
    protected T loaded() {
        return (T)LOADED.get(this);
    }

    protected abstract Logger logger();

    protected void afterLoaded(T value) {
    }

    @Nonnull
    protected Throwable onLoadError(Throwable throwable) {
        return throwable;
    }

    protected Mono<T> requestOnDisposed() {
        return Mono.error((Throwable)new IllegalStateException());
    }

    protected void dispose(T value) {
        if (value instanceof Disposable) {
            ((Disposable)value).dispose();
        }
    }

    protected abstract void doDispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        AsyncLoadCache asyncLoadCache = this;
        synchronized (asyncLoadCache) {
            if (this.loading.isDisposed()) {
                return;
            }
            this.loading.dispose();
        }
        T loaded = LOADED.getAndSet(this, null);
        if (loaded != null) {
            this.dispose(loaded);
        }
        this.doDispose();
    }

    public final boolean isDisposed() {
        return this.loading.isDisposed();
    }

    protected boolean isDisposed(T value) {
        return value instanceof Disposable && ((Disposable)value).isDisposed();
    }

    /*
     * Exception decompiling
     */
    protected final Mono<T> tryLoad() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void subscribe(@Nonnull CoreSubscriber<? super T> actual) {
        this.tryLoad().subscribe(actual);
    }

    private static class LoadingSubscriber<T>
    extends BaseSubscriber<T> {
        private final AsyncLoadCache<T> parent;
        private final Sinks.One<T> awaitRef;

        protected void hookOnNext(@Nonnull T value) {
            Object old = LOADED.getAndSet(this.parent, value);
            if (old != null) {
                this.parent.dispose(old);
            }
            AWAIT.compareAndSet(this.parent, this.awaitRef, null);
            this.awaitRef.emitValue(value, Reactors.emitFailureHandler());
            this.parent.afterLoaded(value);
        }

        protected void hookFinally(@Nonnull SignalType type) {
            if (this.parent.loading.get() == this) {
                this.parent.loading.replace(Disposables.disposed());
            }
            if (AWAIT.get(this.parent) == this.awaitRef) {
                this.awaitRef.emitEmpty(Reactors.emitFailureHandler());
            }
        }

        protected void hookOnError(@Nonnull Throwable throwable) {
            if (Exceptions.isRetryExhausted((Throwable)throwable)) {
                throwable = throwable.getCause();
            }
            throwable = this.parent.onLoadError(throwable);
            AWAIT.compareAndSet(this.parent, this.awaitRef, null);
            this.awaitRef.emitError(throwable, Reactors.emitFailureHandler());
        }

        @Generated
        public LoadingSubscriber(AsyncLoadCache<T> parent, Sinks.One<T> awaitRef) {
            this.parent = parent;
            this.awaitRef = awaitRef;
        }
    }
}

