/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cache;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;
import org.jetlinks.core.cache.FileQueue;
import org.jetlinks.supports.cache.MVStoreQueue;
import org.jetlinks.supports.utils.MVStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CompositeIterator;

class ConcurrencyMVStoreQueue<T>
implements FileQueue<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyMVStoreQueue.class);
    private MVStore store;
    private final AtomicInteger inc = new AtomicInteger();
    private final FastThreadLocal<Integer> QUEUE_HOLDER;
    private final List<MVStoreQueue<T>> queues;
    private final Path filePath;
    private final String name;
    private final Map<String, Object> options;
    private final int concurrency;
    private final AtomicBoolean loading = new AtomicBoolean();
    private final ReadWriteLock loadLock = new ReentrantReadWriteLock();
    private boolean closed;

    ConcurrencyMVStoreQueue(Path filePath, String name, Map<String, Object> options, int concurrency) {
        Files.createDirectories(filePath, new FileAttribute[0]);
        this.filePath = filePath;
        this.name = name;
        this.options = options;
        this.concurrency = concurrency;
        this.queues = new ArrayList<MVStoreQueue<T>>(concurrency);
        this.QUEUE_HOLDER = new FastThreadLocal<Integer>(){

            protected Integer initialValue() {
                return ConcurrencyMVStoreQueue.this.inc.accumulateAndGet(1, (a, b) -> a + 1 >= ConcurrencyMVStoreQueue.this.queues.size() ? 0 : a + 1);
            }
        };
        this.init();
    }

    private void init() {
        this.loadLock.writeLock().lock();
        try {
            if (!this.loading.compareAndSet(false, true) || this.closed) {
                return;
            }
            if (this.store != null) {
                this.store.close(1000);
            }
            this.store = MVStoreUtils.open(this.filePath.resolve(this.name).toFile(), this.name, builder -> builder.cacheSize(64).autoCommitBufferSize(65536).backgroundExceptionHandler((t, e) -> log.warn("{} UncaughtException", (Object)this.name, (Object)e)), store -> {
                this.queues.clear();
                Object type = this.options.get("valueType");
                MVMap.Builder mapBuilder = new MVMap.Builder();
                if (type instanceof DataType) {
                    mapBuilder.valueType((DataType)type);
                }
                HashSet<Object> queueNames = new HashSet<Object>();
                for (int i = 0; i < this.concurrency; ++i) {
                    Object mapName = i == 0 ? "queue" : "queue_" + i;
                    queueNames.add(mapName);
                    this.queues.add(new MVStoreQueue(MVStoreUtils.openMap(store, (String)mapName, mapBuilder)));
                }
                for (Object mapName : store.getMapNames()) {
                    if (!((String)mapName).startsWith("queue") || !queueNames.add(mapName)) continue;
                    this.queues.add(new MVStoreQueue(MVStoreUtils.openMap(store, (String)mapName, mapBuilder)));
                }
                return store;
            });
        }
        finally {
            this.loading.set(false);
            this.loadLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <X> X operationInStore(Callable<X> call) {
        Throwable error;
        int retry = 0;
        do {
            this.loadLock.readLock().lock();
            try {
                X x = call.call();
                return x;
            }
            catch (Throwable e) {
                error = e;
                log.warn("operation mvstore failed!", e);
            }
            finally {
                this.loadLock.readLock().unlock();
            }
            this.init();
        } while (retry++ == 0);
        throw error;
    }

    public void close() {
        if (this.closed || this.store.isClosed()) {
            return;
        }
        this.closed = true;
        if (this.size() >= 1000000) {
            this.store.close(20000);
        } else {
            this.store.close(-1);
        }
        this.QUEUE_HOLDER.remove();
    }

    public void flush() {
        if (this.store.isClosed()) {
            return;
        }
        this.store.compactFile((int)Duration.ofSeconds(30L).toMillis());
    }

    public T removeFirst() {
        return (T)this.operationInStore(() -> {
            for (MVStoreQueue<T> queue : this.queues) {
                T temp = queue.removeFirst();
                if (temp == null) continue;
                return temp;
            }
            return null;
        });
    }

    public T removeLast() {
        return (T)this.operationInStore(() -> {
            for (MVStoreQueue<T> queue : this.queues) {
                T temp = queue.removeLast();
                if (temp == null) continue;
                return temp;
            }
            return null;
        });
    }

    public int size() {
        return this.operationInStore(() -> {
            int size = 0;
            for (MVStoreQueue<T> queue : this.queues) {
                size += queue.size();
            }
            return size;
        });
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException("unsupported operation");
    }

    @Nonnull
    public Iterator<T> iterator() {
        CompositeIterator iterator = new CompositeIterator();
        for (MVStoreQueue<T> queue : this.queues) {
            iterator.add(queue.iterator());
        }
        return iterator;
    }

    @Nonnull
    public Object[] toArray() {
        throw new UnsupportedOperationException("unsupported operation");
    }

    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        throw new UnsupportedOperationException("unsupported operation");
    }

    public boolean add(T t) {
        return this.operationInStore(() -> this.queues.get((Integer)this.QUEUE_HOLDER.get()).add(t));
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends T> c) {
        return this.operationInStore(() -> this.queues.get((Integer)this.QUEUE_HOLDER.get()).addAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.operationInStore(() -> {
            for (MVStoreQueue<T> queue : this.queues) {
                queue.clear();
            }
            return null;
        });
    }

    public boolean offer(T t) {
        return this.operationInStore(() -> this.queues.get((Integer)this.QUEUE_HOLDER.get()).offer(t));
    }

    public T remove() {
        for (MVStoreQueue<T> queue : this.queues) {
            T temp = queue.poll();
            if (temp == null) continue;
            return temp;
        }
        throw new NoSuchElementException("No such element in file " + this.store.getFileStore().getFileName());
    }

    public T poll() {
        return (T)this.operationInStore(() -> {
            T poll = this.queues.get((Integer)this.QUEUE_HOLDER.get()).poll();
            if (poll == null) {
                for (MVStoreQueue<T> queue : this.queues) {
                    poll = queue.poll();
                    if (poll == null) continue;
                    return poll;
                }
            }
            return poll;
        });
    }

    public T element() {
        return (T)this.operationInStore(() -> {
            T poll = this.queues.get((Integer)this.QUEUE_HOLDER.get()).element();
            if (poll == null) {
                for (MVStoreQueue<T> queue : this.queues) {
                    poll = queue.element();
                    if (poll == null) continue;
                    return poll;
                }
            }
            return poll;
        });
    }

    public T peek() {
        return (T)this.operationInStore(() -> {
            T poll = this.queues.get((Integer)this.QUEUE_HOLDER.get()).peek();
            if (poll == null) {
                for (MVStoreQueue<T> queue : this.queues) {
                    poll = queue.peek();
                    if (poll == null) continue;
                    return poll;
                }
            }
            return poll;
        });
    }
}

