/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cache;

import java.io.Externalizable;
import java.io.File;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import lombok.Generated;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jctools.maps.NonBlockingHashMap;
import org.jetlinks.supports.cache.TimeBaseFileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVStoreTimeBaseFileStore<T extends Serializable>
implements TimeBaseFileStore<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MVStoreTimeBaseFileStore.class);
    private static final int DEFAULT_MAX_STORE_SIZE_EACH_KEY = 8;
    private MVStore store;
    private final Map<String, MVMap<String, Refs>> cache = new NonBlockingHashMap();
    private int maxStoreSizeEachKey = 8;

    public MVStoreTimeBaseFileStore(String fileName) {
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            this.store = MVStore.open((String)fileName);
        }
        catch (Throwable err) {
            if (file.exists()) {
                file.renameTo(new File(fileName + "_load_err_" + System.currentTimeMillis()));
                file.delete();
                this.store = MVStore.open((String)fileName);
            }
            throw err;
        }
        this.init();
    }

    public MVStoreTimeBaseFileStore(MVStore store) {
        this.store = store;
        this.init();
    }

    private void init() {
        this.store.getMapNames().forEach(this::getOrCreateCache);
    }

    @Override
    public T get(String name, String key, long time) {
        MVMap<String, Refs> map = this.cache.get(name);
        if (map == null) {
            return null;
        }
        Refs refs = (Refs)map.get((Object)key);
        if (refs != null) {
            Ref ref = refs.getRef(time);
            return (T)(ref == null ? null : (Serializable)ref.value);
        }
        return null;
    }

    @Override
    public void set(String name, String key, long time, T value) {
        Refs refs = (Refs)this.getOrCreateCache(name).computeIfAbsent((Object)key, ignore -> new Refs());
        refs.maxRef = this.maxStoreSizeEachKey;
        refs.update(new Ref(time, value));
    }

    @Override
    public void remove(String name, String key) {
        MVMap<String, Refs> map = this.cache.get(name);
        if (map == null) {
            return;
        }
        map.remove((Object)key);
    }

    @Override
    public void removeAll(String name) {
        this.cache.remove(name);
        this.store.removeMap(name);
    }

    public void dispose() {
        this.store.compactFile((int)Duration.ofSeconds(30L).toMillis());
        this.store.close(-1);
    }

    @Override
    public void clear() {
        this.store.getMapNames().forEach(arg_0 -> ((MVStore)this.store).removeMap(arg_0));
        this.store.commit();
        this.store.compactFile((int)Duration.ofSeconds(30L).toMillis());
    }

    protected MVMap<String, Refs> getOrCreateCache(String key) {
        return this.cache.computeIfAbsent(key, arg_0 -> ((MVStore)this.store).openMap(arg_0));
    }

    @Generated
    public void setMaxStoreSizeEachKey(int maxStoreSizeEachKey) {
        this.maxStoreSizeEachKey = maxStoreSizeEachKey;
    }

    public static class Refs
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Ref[] refs;
        private long minTime = -1L;
        private int maxRef = 8;

        public Ref getRef(long baseTime) {
            for (Ref ref : this.refs) {
                if (ref == null || ref.time > baseTime) continue;
                return ref;
            }
            return null;
        }

        public void update(Ref ref) {
            Ref last;
            if (this.refs == null) {
                this.refs = new Ref[0];
            }
            if (this.minTime > 0L && ref.time < this.minTime) {
                return;
            }
            boolean newEl = false;
            if (this.refs.length < this.maxRef) {
                this.refs = Arrays.copyOf(this.refs, this.refs.length + 1);
                newEl = true;
            }
            if ((last = this.refs[0]) == null || ref.time >= last.time || newEl) {
                this.refs[this.refs.length - 1] = ref;
            } else {
                for (int i = 1; i < this.refs.length; ++i) {
                    last = this.refs[i];
                    if (ref.time == last.time) {
                        this.refs[i] = ref;
                        continue;
                    }
                    if (ref.time <= last.time) continue;
                    System.arraycopy(this.refs, i, this.refs, i + 1, this.refs.length - i - 1);
                    this.refs[i] = ref;
                    break;
                }
            }
            Arrays.sort(this.refs, Comparator.comparingLong(r -> r == null ? 0L : -r.time));
            this.minTime = this.refs[this.refs.length - 1].time;
        }

        @Override
        public void writeExternal(ObjectOutput out) {
            out.writeByte(this.refs == null ? 0 : this.refs.length);
            if (this.refs != null) {
                for (Ref ref : this.refs) {
                    ref.writeExternal(out);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) {
            byte length = in.readByte();
            if (length != 0) {
                this.refs = new Ref[length];
            }
            for (byte i = 0; i < length; i = (byte)(i + 1)) {
                Ref ref = new Ref();
                ref.readExternal(in);
                this.refs[i] = ref;
            }
        }
    }

    public static class Ref
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private long time;
        private Object value;

        @Override
        public void writeExternal(ObjectOutput out) {
            out.writeLong(this.time);
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) {
            this.time = in.readLong();
            this.value = in.readObject();
        }

        public String toString() {
            return "Ref{time=" + this.time + ", value=" + this.value + "}";
        }

        @Generated
        public Ref(long time, Object value) {
            this.time = time;
            this.value = value;
        }

        @Generated
        public Ref() {
        }
    }
}

