/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetlinks.core.cluster.ClusterCache;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractLocalCache<K, V>
implements ClusterCache<K, V> {
    private final Cache<K, Object> cache;
    private final ClusterCache<K, V> clusterCache;
    private final boolean cacheEmpty;
    public static final Object NULL_VALUE = new Object();

    public AbstractLocalCache(ClusterCache<K, V> clusterCache, Cache<K, Object> localCache, boolean cacheEmpty) {
        this.cache = localCache;
        this.clusterCache = clusterCache;
        this.cacheEmpty = cacheEmpty;
    }

    public AbstractLocalCache(ClusterCache<K, V> clusterCache, Cache<K, Object> localCache) {
        this(clusterCache, localCache, true);
    }

    public void clearLocalCache(K key) {
        if ("__all".equals(key)) {
            this.clearAllLocalCache();
        } else if (key != null) {
            this.cache.invalidate(key);
        }
    }

    public void clearAllLocalCache() {
        this.cache.invalidateAll();
    }

    protected abstract Mono<Void> onUpdate(K var1, V var2);

    protected abstract Mono<Void> onRemove(K var1);

    protected abstract Mono<Void> onRemove(Collection<? extends K> var1);

    protected abstract Mono<Void> onClear();

    public Mono<V> get(K key) {
        if (StringUtils.isEmpty(key)) {
            return Mono.empty();
        }
        Object val = this.cache.getIfPresent(key);
        if (val != null) {
            return NULL_VALUE == val ? Mono.empty() : Mono.just((Object)val);
        }
        return this.clusterCache.get(key).switchIfEmpty(this.cacheEmpty ? Mono.fromRunnable(() -> this.cache.put(key, NULL_VALUE)) : Mono.empty()).doOnNext(v -> this.cache.put(key, v));
    }

    public Flux<Map.Entry<K, V>> get(Collection<K> key) {
        if (CollectionUtils.isEmpty(key)) {
            return Flux.empty();
        }
        ImmutableMap all = this.cache.getAllPresent(key);
        if (key.size() == all.size()) {
            return Flux.fromIterable((Iterable)all.entrySet()).map(x$0 -> new SimpleEntry(x$0));
        }
        return this.clusterCache.get(key).doOnNext(kvEntry -> {
            Object k = kvEntry.getKey();
            Object v = kvEntry.getValue();
            if (v == null) {
                if (this.cacheEmpty) {
                    this.cache.put(k, NULL_VALUE);
                }
            } else {
                this.cache.put(k, v);
            }
        });
    }

    public Mono<Boolean> put(K key, V value) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        if (value == null) {
            return this.remove(key);
        }
        return Mono.defer(() -> {
            this.cache.put(key, value);
            return this.clusterCache.put(key, value).flatMap(r -> this.onUpdate(key, value)).thenReturn((Object)true);
        });
    }

    public Mono<Boolean> putIfAbsent(K key, V value) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        if (value == null) {
            return this.remove(key);
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.putIfAbsent(key, value).flatMap(r -> this.onUpdate(key, value).thenReturn(r));
        });
    }

    public Mono<Boolean> remove(K key) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.remove(key).flatMap(r -> this.onRemove(key)).thenReturn((Object)true);
        });
    }

    public Mono<V> getAndRemove(K key) {
        if (key == null) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.getAndRemove(key).flatMap(r -> this.onRemove(key).thenReturn(r));
        });
    }

    public Mono<Boolean> remove(Collection<K> key) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.invalidateAll((Iterable)key);
            return this.clusterCache.remove(key).flatMap(r -> this.onRemove(key)).thenReturn((Object)true);
        });
    }

    public Mono<Boolean> containsKey(K key) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            if (this.clusterCache.containsKey(key) != null) {
                return Mono.just((Object)true);
            }
            return this.clusterCache.containsKey(key);
        });
    }

    public Flux<K> keys() {
        return this.clusterCache.keys();
    }

    public Flux<V> values() {
        return this.clusterCache.values();
    }

    public Mono<Boolean> putAll(Map<? extends K, ? extends V> multi) {
        if (CollectionUtils.isEmpty(multi)) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            List<Object> remove = multi.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
            HashMap newTarget = new HashMap(multi);
            if (remove.size() > 0) {
                this.cache.invalidateAll(remove);
                remove.forEach(newTarget::remove);
            }
            this.cache.putAll(newTarget);
            return this.clusterCache.putAll(multi).then(this.onRemove(multi.keySet())).thenReturn((Object)true);
        });
    }

    public Mono<Integer> size() {
        return this.clusterCache.size();
    }

    public Flux<Map.Entry<K, V>> entries() {
        return this.clusterCache.entries();
    }

    public Mono<Void> clear() {
        return Mono.defer(() -> {
            this.cache.invalidateAll();
            return this.clusterCache.clear().then(this.onClear());
        });
    }

    public Mono<Void> refresh(Collection<? extends K> keys) {
        if (null != keys) {
            this.cache.invalidateAll(keys);
            if (keys.size() == 1) {
                return this.onRemove(keys.iterator().next());
            }
            return this.onRemove(keys);
        }
        return Mono.empty();
    }

    public Mono<Void> refresh() {
        this.cache.invalidateAll();
        return this.onClear();
    }

    class SimpleEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, Object> entry;

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            Object v = this.entry.getValue();
            return v == NULL_VALUE ? null : v;
        }

        @Override
        public V setValue(V value) {
            Object old = this.getValue();
            this.entry.setValue(value);
            return old;
        }

        @Generated
        public SimpleEntry(Map.Entry<K, Object> entry) {
            this.entry = entry;
        }
    }
}

