/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.cache.Caches;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.cluster.ClusterSet;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.defaults.DefaultDeviceOperator;
import org.jetlinks.core.defaults.DefaultDeviceProductOperator;
import org.jetlinks.core.device.CompositeDeviceMessageSenderInterceptor;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperationBroker;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.device.DeviceStateInfo;
import org.jetlinks.core.device.ProductInfo;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.things.ThingRpcSupportChain;
import org.jetlinks.supports.cluster.CompositeDeviceStateChecker;
import org.jetlinks.supports.config.ClusterConfigStorageManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ClusterDeviceRegistry
implements DeviceRegistry {
    private final CompositeDeviceMessageSenderInterceptor interceptor = new CompositeDeviceMessageSenderInterceptor();
    private final ConfigStorageManager manager;
    private final Cache<String, Mono<DeviceOperator>> operatorCache;
    private final Map<String, DeviceProductOperator> productOperatorMap = Caches.newCache();
    private final ProtocolSupports supports;
    private final DeviceOperationBroker handler;
    private final ClusterManager clusterManager;
    private final CompositeDeviceStateChecker stateChecker = new CompositeDeviceStateChecker();
    private ThingRpcSupportChain rpcChain;

    @Deprecated
    public ClusterDeviceRegistry(ProtocolSupports supports, ClusterManager clusterManager, DeviceOperationBroker handler) {
        this(supports, clusterManager, handler, (Cache<String, Mono<DeviceOperator>>)CacheBuilder.newBuilder().softValues().expireAfterAccess(Duration.ofMinutes(30L)).build());
    }

    public ClusterDeviceRegistry(ProtocolSupports supports, ConfigStorageManager storageManager, ClusterManager clusterManager, DeviceOperationBroker handler, Cache<String, Mono<DeviceOperator>> cache) {
        this.supports = supports;
        this.handler = handler;
        this.manager = storageManager;
        this.operatorCache = cache;
        this.clusterManager = clusterManager;
        this.addStateChecker(DefaultDeviceOperator.DEFAULT_STATE_CHECKER);
    }

    @Deprecated
    public ClusterDeviceRegistry(ProtocolSupports supports, ClusterManager clusterManager, DeviceOperationBroker handler, Cache<String, Mono<DeviceOperator>> cache) {
        this.supports = supports;
        this.handler = handler;
        this.manager = new ClusterConfigStorageManager(clusterManager);
        this.operatorCache = cache;
        this.clusterManager = clusterManager;
        this.addStateChecker(DefaultDeviceOperator.DEFAULT_STATE_CHECKER);
    }

    public Flux<DeviceStateInfo> checkDeviceState(Flux<? extends Collection<String>> id) {
        return id.flatMap(list -> Flux.fromIterable((Iterable)list).flatMap(this::getDevice).flatMap(device -> device.getConnectionServerId().defaultIfEmpty((Object)"__").zipWith(Mono.just((Object)device))).groupBy(Tuple2::getT1, Tuple2::getT2).flatMap(group -> {
            if (!StringUtils.hasText((String)((String)group.key())) || "__".equals(group.key())) {
                return group.flatMap(operator -> operator.getState().map(state -> new DeviceStateInfo(operator.getDeviceId(), state.byteValue())));
            }
            return group.map(DeviceOperator::getDeviceId).collectList().flatMapMany(deviceIdList -> this.handler.getDeviceState((String)group.key(), (Collection)deviceIdList));
        }));
    }

    public Mono<DeviceOperator> getDevice(String deviceId) {
        if (ObjectUtils.isEmpty((Object)deviceId)) {
            return Mono.empty();
        }
        Mono deviceOperator = (Mono)this.operatorCache.getIfPresent((Object)deviceId);
        if (null != deviceOperator) {
            return deviceOperator;
        }
        deviceOperator = this.createOperator(deviceId);
        return deviceOperator.getProduct().doOnNext(arg_0 -> this.lambda$getDevice$8(deviceId, (DeviceOperator)deviceOperator, arg_0)).map(arg_0 -> ClusterDeviceRegistry.lambda$getDevice$9((DeviceOperator)deviceOperator, arg_0));
    }

    public Mono<DeviceProductOperator> getProduct(String productId) {
        if (ObjectUtils.isEmpty((Object)productId)) {
            return Mono.empty();
        }
        DeviceProductOperator operator = this.productOperatorMap.get(productId);
        if (null != operator) {
            return Mono.just((Object)operator);
        }
        DefaultDeviceProductOperator deviceOperator = this.createProductOperator(productId);
        return deviceOperator.getConfig((ConfigKey)DeviceConfigKey.protocol).doOnNext(r -> this.productOperatorMap.put(productId, (DeviceProductOperator)deviceOperator)).map(r -> deviceOperator);
    }

    private String createProductCacheKey(String productId, String version) {
        return StringUtils.hasText((String)version) ? productId + ":" + version : productId;
    }

    public Mono<DeviceProductOperator> getProduct(String productId, String version) {
        if (ObjectUtils.isEmpty((Object)productId)) {
            return Mono.empty();
        }
        if (ObjectUtils.isEmpty((Object)version)) {
            return this.getProduct(productId);
        }
        String cacheId = this.createProductCacheKey(productId, version);
        DeviceProductOperator operator = this.productOperatorMap.get(cacheId);
        if (null != operator) {
            return Mono.just((Object)operator);
        }
        operator = this.createProductOperator(productId, version);
        return operator.getConfig((ConfigKey)DeviceConfigKey.protocol).doOnNext(arg_0 -> this.lambda$getProduct$12(cacheId, (DefaultDeviceProductOperator)operator, arg_0)).map(arg_0 -> ClusterDeviceRegistry.lambda$getProduct$13((DefaultDeviceProductOperator)operator, arg_0));
    }

    private DefaultDeviceOperator createOperator(String deviceId) {
        DefaultDeviceOperator device = new DefaultDeviceOperator(deviceId, this.supports, this.manager, this.handler, (DeviceRegistry)this, (DeviceMessageSenderInterceptor)this.interceptor, (DeviceStateChecker)this.stateChecker);
        if (this.rpcChain != null) {
            device.setRpcChain(this.rpcChain);
        }
        return device;
    }

    private DefaultDeviceProductOperator createProductOperator(String id) {
        return new DefaultDeviceProductOperator(id, this.supports, this.manager, () -> this.getProductBind(id, null).values().flatMap(this::getDevice));
    }

    private DefaultDeviceProductOperator createProductOperator(String id, String version) {
        if (StringUtils.isEmpty((Object)version)) {
            return this.createProductOperator(id);
        }
        String storageId = String.join((CharSequence)":", "device-product", id, version);
        return new DefaultDeviceProductOperator(id, this.supports, this.manager.getStorage(storageId), () -> this.getProductBind(id, version).values().flatMap(this::getDevice));
    }

    private ClusterSet<String> getProductBind(String id, String version) {
        return this.clusterManager.getSet(StringUtils.isEmpty((Object)version) ? "device-product-bind:" + id : "device-product-bind:" + id + ":" + version);
    }

    public Mono<DeviceOperator> register(DeviceInfo deviceInfo) {
        return Mono.defer(() -> {
            DefaultDeviceOperator operator = this.createOperator(deviceInfo.getId());
            this.operatorCache.put((Object)operator.getDeviceId(), (Object)Mono.just((Object)operator).filterWhen(device -> device.getSelfConfig((ConfigKey)DeviceConfigKey.productId).hasElement()));
            HashMap configs = new HashMap();
            Optional.ofNullable(deviceInfo.getConfiguration()).ifPresent(configs::putAll);
            Optional.ofNullable(deviceInfo.getMetadata()).ifPresent(conf -> configs.put(DeviceConfigKey.metadata.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProtocol()).ifPresent(conf -> configs.put(DeviceConfigKey.protocol.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProductId()).ifPresent(conf -> configs.put(DeviceConfigKey.productId.getKey(), conf));
            Optional.ofNullable(deviceInfo.getProductVersion()).ifPresent(conf -> configs.put(DeviceConfigKey.productVersion.getKey(), conf));
            return operator.setConfigs(configs).then(operator.getProtocol()).flatMap(protocol -> protocol.onDeviceRegister((DeviceOperator)operator)).then(this.getProductBind(deviceInfo.getProductId(), deviceInfo.getProductVersion()).add((Object)deviceInfo.getId())).thenReturn((Object)operator);
        });
    }

    public Mono<DeviceProductOperator> register(ProductInfo productInfo) {
        return Mono.defer(() -> {
            DefaultDeviceProductOperator operator = this.createProductOperator(productInfo.getId(), productInfo.getVersion());
            String cacheId = this.createProductCacheKey(productInfo.getId(), productInfo.getVersion());
            this.productOperatorMap.put(cacheId, (DeviceProductOperator)operator);
            HashMap configs = new HashMap();
            Optional.ofNullable(productInfo.getConfiguration()).ifPresent(configs::putAll);
            Optional.ofNullable(productInfo.getMetadata()).ifPresent(conf -> configs.put(DeviceConfigKey.metadata.getKey(), conf));
            Optional.ofNullable(productInfo.getProtocol()).ifPresent(conf -> configs.put(DeviceConfigKey.protocol.getKey(), conf));
            Optional.ofNullable(productInfo.getVersion()).ifPresent(conf -> configs.put(DeviceConfigKey.productVersion.getKey(), conf));
            return operator.setConfigs(configs).then(operator.getProtocol()).flatMap(protocol -> protocol.onProductRegister((DeviceProductOperator)operator)).thenReturn((Object)operator);
        });
    }

    public Mono<Void> unregisterDevice(String deviceId) {
        return this.getDevice(deviceId).flatMap(this::doUnregister).doFinally(r -> this.operatorCache.invalidate((Object)deviceId)).then();
    }

    public Mono<Void> unregisterProduct(String productId) {
        return this.getProduct(productId).flatMap(this::doUnregister).doFinally(r -> this.productOperatorMap.remove(this.createProductCacheKey(productId, null)));
    }

    public Mono<Void> unregisterProduct(String productId, String version) {
        return this.getProduct(productId, version).flatMap(this::doUnregister).doFinally(r -> this.productOperatorMap.remove(this.createProductCacheKey(productId, version)));
    }

    protected Mono<Void> doUnregister(DeviceProductOperator product) {
        return product.getProtocol().flatMap(protocol -> protocol.onProductUnRegister(product)).then(((DefaultDeviceProductOperator)product.unwrap(DefaultDeviceProductOperator.class)).getReactiveStorage().flatMap(ConfigStorage::clear)).then();
    }

    protected Mono<Void> doUnregister(DeviceOperator device) {
        return device.getProtocol().flatMap(protocol -> protocol.onDeviceUnRegister(device)).then(((DefaultDeviceOperator)device.unwrap(DefaultDeviceOperator.class)).getReactiveStorage().flatMap(ConfigStorage::clear)).then();
    }

    public void addInterceptor(DeviceMessageSenderInterceptor interceptor) {
        this.interceptor.addInterceptor(interceptor);
    }

    public void addStateChecker(DeviceStateChecker deviceStateChecker) {
        this.stateChecker.addDeviceStateChecker(deviceStateChecker);
    }

    public void addRpcChain(ThingRpcSupportChain chain) {
        this.rpcChain = this.rpcChain == null ? chain : this.rpcChain.composite(Collections.singleton(chain));
    }

    @Generated
    public void setRpcChain(ThingRpcSupportChain rpcChain) {
        this.rpcChain = rpcChain;
    }

    private static /* synthetic */ DeviceProductOperator lambda$getProduct$13(DefaultDeviceProductOperator operator, String r) {
        return operator;
    }

    private /* synthetic */ void lambda$getProduct$12(String cacheId, DefaultDeviceProductOperator operator, String r) {
        this.productOperatorMap.put(cacheId, (DeviceProductOperator)operator);
    }

    private static /* synthetic */ DeviceOperator lambda$getDevice$9(DeviceOperator deviceOperator, DeviceProductOperator ignore) {
        return deviceOperator;
    }

    private /* synthetic */ void lambda$getDevice$8(String deviceId, DeviceOperator deviceOperator, DeviceProductOperator r) {
        this.operatorCache.put((Object)deviceId, (Object)deviceOperator.getProduct().map(ignore -> deviceOperator).switchIfEmpty(Mono.fromRunnable(() -> this.operatorCache.invalidate((Object)deviceId))));
    }
}

