/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.command;

import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.Wrapper;
import org.jetlinks.core.annotation.Attr;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.AbstractCommandSupport;
import org.jetlinks.core.command.AbstractStreamCommand;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandConstant;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandMetadataResolver;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.command.StreamCommand;
import org.jetlinks.core.command.TemplateCommandSupport;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.utils.MetadataUtils;
import org.jetlinks.supports.official.DeviceMetadataParser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MethodInvocationException;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public class JavaBeanCommandSupport
extends AbstractCommandSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaBeanCommandSupport.class);
    private static final Predicate<Method> defaultFilter = method -> {
        org.jetlinks.core.annotation.command.CommandHandler annotation = (org.jetlinks.core.annotation.command.CommandHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class);
        return !Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getDeclaringClass() != Object.class && (annotation == null || !annotation.ignore());
    };
    protected final Object target;
    protected final ResolvableType targetType;
    private static final MetadataHandler DO_NOTHING_HANDLER = (target, cmd, metadata) -> Mono.just((Object)metadata);

    public static JavaBeanCommandSupport create(Object instance) {
        return new JavaBeanCommandSupport(instance);
    }

    public static JavaBeanCommandSupport createTemplate(Class<?> type) {
        return JavaBeanCommandSupport.createTemplate(ResolvableType.forType(type));
    }

    public static JavaBeanCommandSupport createTemplate(ResolvableType type) {
        return new JavaBeanCommandSupport(type);
    }

    public JavaBeanCommandSupport(Object target, Collection<String> filter) {
        this(target, (Method m) -> filter.contains(m.getName()));
    }

    public JavaBeanCommandSupport(Object target, Predicate<Method> filter) {
        this.target = target;
        this.targetType = ResolvableType.forType((Type)ClassUtils.getUserClass((Object)target));
        this.init(defaultFilter.and(filter));
    }

    public JavaBeanCommandSupport(Object target) {
        this(target, (Method method) -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class) != null);
    }

    JavaBeanCommandSupport(ResolvableType targetType, Collection<String> filter) {
        this(targetType, (Method m) -> filter.contains(m.getName()));
    }

    JavaBeanCommandSupport(ResolvableType targetType, Predicate<Method> filter) {
        this.target = null;
        this.targetType = targetType;
        this.init(defaultFilter.and(filter));
    }

    JavaBeanCommandSupport(ResolvableType targetType) {
        this(targetType, (Method method) -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class) != null);
    }

    private void init(Predicate<Method> filter) {
        ReflectionUtils.doWithMethods((Class)this.targetType.toClass(), method -> {
            if (filter.test(method)) {
                this.register(method);
            }
        });
    }

    private boolean returnIsVoid(ResolvableType type) {
        if (type.getGenerics().length > 0) {
            return this.returnIsVoid(type.getGeneric(new int[]{0}));
        }
        return type.toClass() == Void.class || type.toClass() == Void.TYPE;
    }

    private static Object doInvoke(Object target, Method method, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (MethodInvocationException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public List<CommandHandler<Command<?>, ?>> getHandlers() {
        return this.handlers.values().stream().distinct().collect(Collectors.toList());
    }

    private void register(Method method) {
        String id;
        ResolvableType owner = this.targetType;
        Schema schema = (Schema)AnnotationUtils.findAnnotation((Method)method, Schema.class);
        ReflectionUtils.makeAccessible((Method)method);
        Object target = this.target;
        String name = id = schema != null && StringUtils.hasText((String)schema.name()) ? schema.name() : method.getName();
        String description = id;
        MethodDesc desc = new MethodDesc(owner, method);
        ResolvableType returnType = ResolvableType.forMethodParameter((MethodParameter)new MethodParameter(method, -1), (ResolvableType)owner);
        DataType output = null;
        MethodInvoker invoker = null;
        Parameter[] parameters = desc.parameters;
        String[] argNames = desc.argNames;
        Map expands = null;
        List<SimplePropertyMetadata> inputs = new ArrayList();
        ResolvableType[] argTypes = desc.argTypes;
        if (!this.returnIsVoid(returnType)) {
            output = DeviceMetadataParser.withType(returnType);
        }
        if (argTypes.length == 0) {
            invoker = (_target, ignore) -> JavaBeanCommandSupport.doInvoke(_target, method, new Object[0]);
        } else {
            if (argTypes.length == 1) {
                if (Command.class.isAssignableFrom(argTypes[0].toClass())) {
                    invoker = new CommandInvoker(method, argTypes[0]);
                    FunctionMetadata resolve = CommandMetadataResolver.resolve((ResolvableType)desc.argTypes[0], (ResolvableType)ResolvableType.NONE);
                    id = resolve.getId();
                    name = resolve.getName();
                    description = resolve.getDescription();
                    inputs = resolve.getInputs();
                    expands = resolve.getExpands();
                } else {
                    RequestBody requestBody = (RequestBody)AnnotationUtils.findAnnotation((AnnotatedElement)method.getParameters()[0], RequestBody.class);
                    if (requestBody != null) {
                        DataType metadataType = DeviceMetadataParser.withType(argTypes[0]);
                        if (metadataType instanceof ObjectType) {
                            inputs = ((ObjectType)metadataType).getProperties();
                        }
                        Class type = argTypes[0].toClass();
                        invoker = (_target, cmd) -> {
                            Object param = cmd.as(type);
                            return JavaBeanCommandSupport.doInvoke(_target, method, param);
                        };
                    }
                }
            }
            if (invoker == null) {
                for (int i = 0; i < argTypes.length; ++i) {
                    ResolvableType type = argTypes[i];
                    Parameter parameter = parameters[i];
                    Schema schemaAnn = parameter.getAnnotation(Schema.class);
                    DataType dataType = DeviceMetadataParser.withType(type);
                    SimplePropertyMetadata metadata = new SimplePropertyMetadata();
                    metadata.setId(argNames[i]);
                    metadata.setDescription(schemaAnn == null ? null : schemaAnn.description());
                    metadata.setName(schemaAnn != null && StringUtils.hasText((String)schemaAnn.title()) ? schemaAnn.title() : metadata.getId());
                    metadata.setValueType(dataType);
                    MetadataUtils.parseExpands((Annotation[])parameter.getAnnotations()).forEach((arg_0, arg_1) -> ((SimplePropertyMetadata)metadata).expand(arg_0, arg_1));
                    inputs.add(metadata);
                }
                invoker = (_target, cmd) -> {
                    Object[] args = new Object[argTypes.length];
                    for (int i = 0; i < argTypes.length; ++i) {
                        ResolvableType type = argTypes[i];
                        args[i] = cmd.getOrNull(argNames[i], type.getType());
                    }
                    return JavaBeanCommandSupport.doInvoke(_target, method, args);
                };
            }
        }
        SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
        metadata.setId(id);
        metadata.setOutput(output);
        metadata.setInputs(inputs);
        metadata.setName(schema != null && StringUtils.hasText((String)schema.title()) ? schema.title() : name);
        metadata.setDescription(schema != null && StringUtils.hasText((String)schema.description()) ? schema.description() : description);
        if (expands != null) {
            expands.forEach((arg_0, arg_1) -> ((SimpleFunctionMetadata)metadata).expand(arg_0, arg_1));
        }
        MethodCallCommandHandler handler = new MethodCallCommandHandler(this.target, this.wrapInvoker(method, invoker), this.applyMetadata(method, argTypes, metadata), this.createMetadataHandler(owner, method), method);
        this.registerHandlerAbsent(metadata.getId(), handler);
    }

    protected <C extends Command<R>, R> void registerHandlerAbsent(String id, CommandHandler<C, R> handler) {
        this.handlers.computeIfAbsent(id, k -> handler);
    }

    private MetadataHandler createMetadataHandler(ResolvableType owner, Method method) {
        org.jetlinks.core.annotation.command.CommandHandler annotation = (org.jetlinks.core.annotation.command.CommandHandler)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class);
        if (annotation == null || !StringUtils.hasText((String)annotation.outputProvider())) {
            return DO_NOTHING_HANDLER;
        }
        String provider = annotation.outputProvider();
        Method providerMethod = ReflectionUtils.findMethod((Class)this.targetType.toClass(), (String)provider, (Class[])null);
        if (providerMethod == null) {
            log.warn("outputProvider method [{}] not found", (Object)provider);
            return DO_NOTHING_HANDLER;
        }
        MethodDesc desc = new MethodDesc(owner, providerMethod);
        ResolvableType returnType = desc.returnType;
        if (!DataType.class.isAssignableFrom(CommandUtils.getCommandResponseDataType((ResolvableType)returnType).toClass()) && !FunctionMetadata.class.isAssignableFrom(CommandUtils.getCommandResponseDataType((ResolvableType)returnType).toClass())) {
            log.warn("outputProvider method [{}] return type not DataType or FunctionMetadata for {}", (Object)provider, (Object)method);
            return DO_NOTHING_HANDLER;
        }
        return new DefaultMetadataHandler(desc.createMethodInvoker());
    }

    protected SimpleFunctionMetadata applyMetadata(Method method, ResolvableType[] argTypes, SimpleFunctionMetadata metadata) {
        org.jetlinks.core.annotation.command.CommandHandler annotation = (org.jetlinks.core.annotation.command.CommandHandler)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, org.jetlinks.core.annotation.command.CommandHandler.class);
        if (annotation == null) {
            return metadata;
        }
        if (annotation.value() != Command.class) {
            FunctionMetadata resolve = CommandMetadataResolver.resolve((Class)annotation.value(), Object.class);
            metadata.setId(resolve.getId());
            metadata.setName(resolve.getName());
            metadata.setDescription(resolve.getDescription());
            metadata.setInputs(resolve.getInputs());
        }
        if (StringUtils.hasText((String)annotation.id())) {
            metadata.setId(annotation.id());
        }
        if (StringUtils.hasText((String)annotation.name())) {
            metadata.setName(LocaleUtils.resolveMessage((String)annotation.name(), (String)annotation.name(), (Object[])new Object[0]));
        }
        if (StringUtils.hasText((String)annotation.description())) {
            metadata.setDescription(annotation.description());
        }
        MetadataUtils.parseExpands((AnnotatedElement)method).forEach((arg_0, arg_1) -> ((SimpleFunctionMetadata)metadata).expand(arg_0, arg_1));
        MetadataUtils.resolveAttrs((Attr[])annotation.expands(), (arg_0, arg_1) -> ((SimpleFunctionMetadata)metadata).expand(arg_0, arg_1));
        if (metadata.getExpand(CommandConstant.responseFlux).isEmpty()) {
            metadata.expand(CommandConstant.responseFlux, (Object)Flux.class.isAssignableFrom(method.getReturnType()));
        }
        if (metadata.getExpand(CommandConstant.responseReactive).isEmpty()) {
            metadata.expand(CommandConstant.responseReactive, (Object)Publisher.class.isAssignableFrom(method.getReturnType()));
        }
        if (!Void.class.equals((Object)annotation.inputSpec())) {
            metadata.setInputs(CommandMetadataResolver.resolveInputs((ResolvableType)ResolvableType.forType((Type)annotation.inputSpec())));
        }
        if (!Void.class.equals((Object)annotation.outputSpec())) {
            metadata.setOutput(CommandMetadataResolver.resolveOutput((ResolvableType)ResolvableType.forType((Type)annotation.outputSpec())));
        }
        return metadata;
    }

    public CommandSupport copyWith(Object target) {
        return new CopyJavaBeanCommandSupport(this, target);
    }

    public List<CommandHandler<?, ?>> copyHandlerWith(Object target) {
        return this.handlers.values().stream().filter(MethodCallCommandHandler.class::isInstance).map(h -> ((MethodCallCommandHandler)MethodCallCommandHandler.class.cast(h)).copy(target)).collect(Collectors.toList());
    }

    protected MethodInvoker wrapInvoker(Method method, MethodInvoker invoker) {
        return new TraceMethodInvoker(method, invoker);
    }

    public String toString() {
        return this.handlers.values().toString();
    }

    private static class MethodDesc {
        final ResolvableType[] argTypes;
        final String[] argNames;
        final Method method;
        final ResolvableType returnType;
        final Parameter[] parameters;

        public MethodDesc(ResolvableType owner, Method method) {
            this.method = method;
            this.argTypes = new ResolvableType[method.getParameterCount()];
            this.argNames = new String[method.getParameterCount()];
            this.parameters = method.getParameters();
            for (int i = 0; i < method.getParameterCount(); ++i) {
                this.argTypes[i] = ResolvableType.forMethodParameter((MethodParameter)new MethodParameter(method, i), (ResolvableType)owner);
            }
            String[] discoveredArgName = MethodInterceptorHolder.nameDiscoverer.getParameterNames(method);
            if (this.argTypes.length > 0 && discoveredArgName == null) {
                log.warn("\u65e0\u6cd5\u89e3\u6790\u65b9\u6cd5\u53c2\u6570\u540d,\u8bf7\u7f16\u8bd1\u65f6\u589e\u52a0-parameters\u53c2\u6570:{}", (Object)method);
            }
            for (int i = 0; i < this.argNames.length; ++i) {
                Parameter parameter = this.parameters[i];
                Schema schemaAnn = parameter.getAnnotation(Schema.class);
                this.argNames[i] = schemaAnn != null && StringUtils.hasText((String)schemaAnn.name()) ? schemaAnn.name() : (discoveredArgName != null && discoveredArgName.length > i ? discoveredArgName[i] : "arg" + i);
            }
            this.returnType = ResolvableType.forMethodParameter((MethodParameter)new MethodParameter(method, -1), (ResolvableType)owner);
        }

        public MethodInvoker createMethodInvoker() {
            ResolvableType[] argTypes = this.argTypes;
            String[] argNames = this.argNames;
            Method method = this.method;
            ReflectionUtils.makeAccessible((Method)method);
            if (argTypes.length == 0) {
                return (target, ignore) -> JavaBeanCommandSupport.doInvoke(target, method, new Object[0]);
            }
            if (argTypes.length == 1 && Command.class.isAssignableFrom(argTypes[0].toClass())) {
                return new CommandInvoker(method, argTypes[0]);
            }
            RequestBody requestBody = (RequestBody)AnnotationUtils.findAnnotation((AnnotatedElement)this.parameters[0], RequestBody.class);
            if (requestBody != null) {
                Class type = argTypes[0].toClass();
                return (target, cmd) -> {
                    Object param = cmd.as(type);
                    return JavaBeanCommandSupport.doInvoke(target, method, param);
                };
            }
            return (target, cmd) -> {
                Object[] args = new Object[argTypes.length];
                for (int i = 0; i < argTypes.length; ++i) {
                    ResolvableType type = argTypes[i];
                    args[i] = cmd.getOrNull(argNames[i], type.getType());
                }
                return JavaBeanCommandSupport.doInvoke(target, method, args);
            };
        }
    }

    protected static interface MethodInvoker
    extends BiFunction<Object, Command<Object>, Object>,
    Wrapper {
    }

    static class CommandInvoker
    implements MethodInvoker,
    Supplier<Command<Object>> {
        private final Method method;
        private final ResolvableType type;

        public CommandInvoker(Method method, ResolvableType type) {
            this.method = method;
            this.type = type;
        }

        @Override
        public Object apply(Object target, Command<Object> objectCommand) {
            if (this.type.toClass().isInstance(objectCommand)) {
                return JavaBeanCommandSupport.doInvoke(target, this.method, objectCommand);
            }
            return JavaBeanCommandSupport.doInvoke(target, this.method, this.createCommand().with(objectCommand));
        }

        @Override
        public Command<Object> get() {
            return this.createCommand();
        }

        private Command<Object> createCommand() {
            Command cmd = (Command)this.type.toClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return cmd;
        }
    }

    static class MethodCallCommandHandler
    implements CommandHandler<Command<Object>, Object> {
        private final Object target;
        private final MethodInvoker invoker;
        private final SimpleFunctionMetadata metadata;
        private final MetadataHandler metadataHandler;
        private final Method method;

        private Object call0(Object target, Command<Object> command) {
            return this.invoker.apply(target, command);
        }

        private MethodCallCommandHandler copy(Object target) {
            return new MethodCallCommandHandler(target, this.invoker, this.metadata, this.metadataHandler, this.method);
        }

        private Mono<FunctionMetadata> getMetadata0(Object target, Command<?> cmd) {
            return this.metadataHandler.apply(target, cmd, this.metadata);
        }

        private Object handle0(Object target, @Nonnull Command<Object> command, @Nonnull CommandSupport support) {
            if (target == null) {
                throw new UnsupportedOperationException("unsupported call not implement method " + this.method);
            }
            Object result = this.call0(target, command);
            if (command.isWrapperFor(StreamCommand.class) || this.metadata.getExpand(CommandConstant.responseFlux).orElse(false).booleanValue()) {
                return CommandUtils.convertResponseToFlux((Object)result, command);
            }
            return result;
        }

        public Object handle(@Nonnull Command<Object> command, @Nonnull CommandSupport support) {
            return this.handle0(this.target, command, support);
        }

        public Mono<FunctionMetadata> getMetadata(Command<?> cmd) {
            return this.getMetadata0(this.target, cmd);
        }

        @Nonnull
        public Command<Object> createCommand() {
            if (this.invoker.isWrapperFor(CommandInvoker.class)) {
                return ((CommandInvoker)this.invoker.unwrap(CommandInvoker.class)).createCommand();
            }
            if (this.metadata.getExpand(CommandConstant.responseFlux).orElse(false).booleanValue()) {
                return new MethodCallFluxCommand(this.metadata.getId());
            }
            if (CommandConstant.isStream((Metadata)this.metadata)) {
                return new MethodCallStreamCommand(this.metadata.getId());
            }
            return new MethodCallCommand(this.metadata.getId());
        }

        public FunctionMetadata getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return String.valueOf(this.method);
        }

        @Generated
        public MethodCallCommandHandler(Object target, MethodInvoker invoker, SimpleFunctionMetadata metadata, MetadataHandler metadataHandler, Method method) {
            this.target = target;
            this.invoker = invoker;
            this.metadata = metadata;
            this.metadataHandler = metadataHandler;
            this.method = method;
        }
    }

    static interface MetadataHandler
    extends Function3<Object, Command<?>, SimpleFunctionMetadata, Mono<FunctionMetadata>> {
        public Mono<FunctionMetadata> apply(Object var1, Command<?> var2, SimpleFunctionMetadata var3);
    }

    private static class DefaultMetadataHandler
    implements MetadataHandler {
        private final MethodInvoker invoker;

        private Mono<FunctionMetadata> convertMetadata(Object data, SimpleFunctionMetadata metadata) {
            if (data instanceof FunctionMetadata) {
                return Mono.just((Object)((FunctionMetadata)data));
            }
            if (data instanceof DataType) {
                metadata = metadata.copy();
                metadata.setOutput((DataType)data);
            }
            return Mono.just((Object)metadata);
        }

        @Override
        public Mono<FunctionMetadata> apply(Object target, Command<?> objectCommand, SimpleFunctionMetadata metadata) {
            return (Mono)Mono.defer(() -> {
                Object object = this.invoker.apply(target, objectCommand);
                if (object instanceof Publisher) {
                    return Mono.from((Publisher)((Publisher)object)).flatMap(data -> this.convertMetadata(data, metadata));
                }
                return this.convertMetadata(object, metadata);
            }).as(LocaleUtils::transform);
        }

        @Generated
        public DefaultMetadataHandler(MethodInvoker invoker) {
            this.invoker = invoker;
        }
    }

    static class CopyJavaBeanCommandSupport
    extends TemplateCommandSupport {
        private final Object target;

        public CopyJavaBeanCommandSupport(JavaBeanCommandSupport parent, Object target) {
            super((CommandSupport)parent);
            this.target = target;
        }

        @Nonnull
        public <R> R execute(@Nonnull Command<R> command) {
            JavaBeanCommandSupport parent = (JavaBeanCommandSupport)((Object)this.template.unwrap(JavaBeanCommandSupport.class));
            CommandHandler handler = (CommandHandler)parent.handlers.get(command.getCommandId());
            if (handler instanceof MethodCallCommandHandler) {
                return (R)((MethodCallCommandHandler)handler).handle0(this.target, command, (CommandSupport)parent);
            }
            if (handler == null) {
                return (R)parent.executeUndefinedCommand(command);
            }
            return (R)handler.handle(command, (CommandSupport)parent);
        }

        public Mono<FunctionMetadata> getCommandMetadata(@Nonnull String commandId, @Nullable Map<String, Object> parameters) {
            if (MapUtils.isEmpty(parameters)) {
                return this.getCommandMetadata(commandId);
            }
            return this.createCommandAsync(commandId).flatMap(cmd -> this.getCommandMetadata(cmd.with(parameters)));
        }

        public Mono<FunctionMetadata> getCommandMetadata(Command<?> command) {
            JavaBeanCommandSupport parent = (JavaBeanCommandSupport)((Object)this.template.unwrap(JavaBeanCommandSupport.class));
            CommandHandler handler = (CommandHandler)parent.handlers.get(command.getCommandId());
            if (handler.isWrapperFor(MethodCallCommandHandler.class)) {
                return ((MethodCallCommandHandler)handler.unwrap(MethodCallCommandHandler.class)).getMetadata0(this.target, command);
            }
            return super.getCommandMetadata(command);
        }
    }

    protected static class TraceMethodInvoker
    implements MethodInvoker {
        private static final SharedPathString TRACE_TEMPLATE = SharedPathString.of((String)"/java/command");
        private final Method method;
        private final MethodInvoker invoker;

        TraceMethodInvoker(Method method, MethodInvoker invoker) {
            this.method = method;
            this.invoker = invoker;
        }

        protected SeparatedCharSequence spanPrefix() {
            return TRACE_TEMPLATE;
        }

        @Override
        public Object apply(Object o, Command<Object> objectCommand) {
            if (TraceHolder.isDisabled()) {
                return this.invoker.apply(o, objectCommand);
            }
            SeparatedCharSequence span = this.spanPrefix().append(new CharSequence[]{ClassUtils.getUserClass((Object)o).getSimpleName(), this.method.getName()});
            if (Mono.class.isAssignableFrom(this.method.getReturnType())) {
                return Mono.defer(() -> (Mono)this.invoker.apply(o, objectCommand)).as((Function)MonoTracer.create((CharSequence)span));
            }
            if (Flux.class.isAssignableFrom(this.method.getReturnType())) {
                return Flux.defer(() -> (Flux)this.invoker.apply(o, objectCommand)).as((Function)FluxTracer.create((CharSequence)span));
            }
            return TraceHolder.traceBlocking((CharSequence)span, ignore -> this.invoker.apply(o, objectCommand));
        }

        public boolean isWrapperFor(Class<?> type) {
            return this.invoker.isWrapperFor(type);
        }

        public <T> T unwrap(Class<T> type) {
            return (T)this.invoker.unwrap(type);
        }
    }

    public static class MethodCallCommand
    extends AbstractCommand<Object, MethodCallCommand> {
        private String commandId;

        @Generated
        public String getCommandId() {
            return this.commandId;
        }

        @Generated
        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public MethodCallCommand(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public MethodCallCommand() {
        }
    }

    public static class MethodCallFluxCommand
    extends AbstractCommand<Flux<Object>, MethodCallFluxCommand> {
        private String commandId;

        @Generated
        public String getCommandId() {
            return this.commandId;
        }

        @Generated
        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public MethodCallFluxCommand(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public MethodCallFluxCommand() {
        }
    }

    public static class MethodCallStreamCommand
    extends AbstractStreamCommand<Object, Object, MethodCallStreamCommand> {
        private String commandId;

        public Object createResponseData(Object value) {
            return value;
        }

        public Object convertStreamValue(Object value) {
            return value;
        }

        @Generated
        public String getCommandId() {
            return this.commandId;
        }

        @Generated
        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public MethodCallStreamCommand(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public MethodCallStreamCommand() {
        }
    }
}

