/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.metadata.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.metadata.types.UnknownType;
import org.jetlinks.core.utils.json.ObjectMappers;

public class JsonSchemaTypeMapper {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMappers.JSON_MAPPER;

    public static DataType mapToDataType(JsonNode schemaJson) {
        String type;
        if (!schemaJson.has("type")) {
            return new UnknownType();
        }
        return switch (type = schemaJson.get("type").asText()) {
            case "string" -> JsonSchemaTypeMapper.mapStringType(schemaJson);
            case "number" -> JsonSchemaTypeMapper.mapNumberType(schemaJson);
            case "integer" -> JsonSchemaTypeMapper.mapIntegerType(schemaJson);
            case "boolean" -> new BooleanType();
            case "object" -> JsonSchemaTypeMapper.mapObjectType(schemaJson);
            case "array" -> JsonSchemaTypeMapper.mapArrayType(schemaJson);
            default -> new UnknownType();
        };
    }

    public static JsonNode mapFromDataType(DataType dataType) {
        ObjectNode schema = OBJECT_MAPPER.createObjectNode();
        JsonSchemaTypeMapper.mapDataTypeToSchema(dataType, schema);
        return schema;
    }

    public static JsonNode mapFromProperty(PropertyMetadata propertyMetadata) {
        DataType dataType;
        ObjectNode schema = OBJECT_MAPPER.createObjectNode();
        if (propertyMetadata.getId() != null) {
            schema.put("$id", propertyMetadata.getId());
        }
        if (propertyMetadata.getName() != null) {
            schema.put("title", propertyMetadata.getName());
        }
        if (propertyMetadata.getDescription() != null) {
            schema.put("description", propertyMetadata.getDescription());
        }
        if ((dataType = propertyMetadata.getValueType()) == null) {
            return schema;
        }
        JsonSchemaTypeMapper.mapDataTypeToSchema(dataType, schema);
        Map expands = propertyMetadata.getExpands();
        if (expands != null && !expands.isEmpty()) {
            JsonSchemaTypeMapper.mapExpandsToSchema(expands, schema);
        }
        return schema;
    }

    private static DataType mapStringType(JsonNode schemaJson) {
        if (schemaJson.has("format")) {
            String format;
            switch (format = schemaJson.get("format").asText()) {
                case "date-time": {
                    return new DateTimeType();
                }
                case "password": {
                    return new PasswordType();
                }
            }
            StringType stringType = new StringType();
            stringType.expand("format", (Object)format);
            return JsonSchemaTypeMapper.applyStringConstraints(stringType, schemaJson);
        }
        if (schemaJson.has("enum")) {
            JsonNode enumArray = schemaJson.get("enum");
            EnumType enumType = new EnumType();
            for (JsonNode enumValue : enumArray) {
                if (!enumValue.isTextual()) continue;
                String value = enumValue.asText();
                enumType.addElement(EnumType.Element.of((String)value, (String)value));
            }
            return enumType;
        }
        StringType stringType = new StringType();
        return JsonSchemaTypeMapper.applyStringConstraints(stringType, schemaJson);
    }

    private static StringType applyStringConstraints(StringType stringType, JsonNode schemaJson) {
        if (schemaJson.has("minLength")) {
            stringType.expand("minLength", (Object)schemaJson.get("minLength").asInt());
        }
        if (schemaJson.has("maxLength")) {
            stringType.expand("maxLength", (Object)schemaJson.get("maxLength").asInt());
        }
        if (schemaJson.has("pattern")) {
            stringType.expand("pattern", (Object)schemaJson.get("pattern").asText());
        }
        return stringType;
    }

    private static DataType mapNumberType(JsonNode schemaJson) {
        DoubleType doubleType = new DoubleType();
        if (schemaJson.has("minimum")) {
            doubleType.expand("min", (Object)schemaJson.get("minimum").asDouble());
        }
        if (schemaJson.has("maximum")) {
            doubleType.expand("max", (Object)schemaJson.get("maximum").asDouble());
        }
        if (schemaJson.has("multipleOf")) {
            doubleType.expand("step", (Object)schemaJson.get("multipleOf").asDouble());
        }
        return doubleType;
    }

    private static DataType mapIntegerType(JsonNode schemaJson) {
        IntType intType = new IntType();
        if (schemaJson.has("minimum")) {
            long min = schemaJson.get("minimum").asLong();
            if (min >= Integer.MIN_VALUE && min <= Integer.MAX_VALUE) {
                intType.expand("min", (Object)((int)min));
            } else {
                LongType longType = new LongType();
                longType.expand("min", (Object)min);
                if (schemaJson.has("maximum")) {
                    longType.expand("max", (Object)schemaJson.get("maximum").asLong());
                }
                return longType;
            }
        }
        if (schemaJson.has("maximum")) {
            long max = schemaJson.get("maximum").asLong();
            if (max >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE) {
                intType.expand("max", (Object)((int)max));
            } else {
                LongType longType = new LongType();
                longType.expand("max", (Object)max);
                if (schemaJson.has("minimum")) {
                    longType.expand("min", (Object)schemaJson.get("minimum").asLong());
                }
                return longType;
            }
        }
        return intType;
    }

    private static ObjectType mapObjectType(JsonNode schemaJson) {
        ObjectType objectType = new ObjectType();
        if (schemaJson.has("properties")) {
            JsonNode properties = schemaJson.get("properties");
            properties.fieldNames().forEachRemaining(propertyName -> {
                JsonNode propertySchema = properties.get(propertyName);
                DataType propertyType = JsonSchemaTypeMapper.mapToDataType(propertySchema);
                SimplePropertyMetadata propertyMetadata = new SimplePropertyMetadata();
                propertyMetadata.setId(propertyName);
                propertyMetadata.setValueType(propertyType);
                if (propertySchema.has("title")) {
                    propertyMetadata.setName(propertySchema.get("title").asText());
                } else {
                    propertyMetadata.setName(propertyName);
                }
                if (propertySchema.has("description")) {
                    propertyMetadata.setDescription(propertySchema.get("description").asText());
                }
                objectType.addPropertyMetadata((PropertyMetadata)propertyMetadata);
            });
        }
        return objectType;
    }

    private static ArrayType mapArrayType(JsonNode schemaJson) {
        JsonNode items;
        ArrayType arrayType = new ArrayType();
        if (schemaJson.has("items") && (items = schemaJson.get("items")).isObject()) {
            DataType elementType = JsonSchemaTypeMapper.mapToDataType(items);
            arrayType.setElementType(elementType);
        }
        if (schemaJson.has("minItems")) {
            arrayType.expand("minItems", (Object)schemaJson.get("minItems").asInt());
        }
        if (schemaJson.has("maxItems")) {
            arrayType.expand("maxItems", (Object)schemaJson.get("maxItems").asInt());
        }
        return arrayType;
    }

    private static void mapDataTypeToSchema(DataType dataType, ObjectNode schema) {
        String typeId;
        switch (typeId = dataType.getId()) {
            case "string": {
                schema.put("type", "string");
                JsonSchemaTypeMapper.mapStringTypeToSchema((StringType)dataType, schema);
                break;
            }
            case "int": 
            case "long": 
            case "short": 
            case "byte": {
                schema.put("type", "integer");
                JsonSchemaTypeMapper.mapNumberTypeToSchema(dataType, schema);
                break;
            }
            case "double": 
            case "float": {
                schema.put("type", "number");
                JsonSchemaTypeMapper.mapNumberTypeToSchema(dataType, schema);
                break;
            }
            case "boolean": {
                schema.put("type", "boolean");
                break;
            }
            case "object": {
                schema.put("type", "object");
                JsonSchemaTypeMapper.mapObjectTypeToSchema((ObjectType)dataType, schema);
                break;
            }
            case "array": {
                schema.put("type", "array");
                JsonSchemaTypeMapper.mapArrayTypeToSchema((ArrayType)dataType, schema);
                break;
            }
            case "enum": {
                JsonSchemaTypeMapper.mapEnumTypeToSchema((EnumType)dataType, schema);
                break;
            }
            case "date": {
                schema.put("type", "string");
                schema.put("format", "date-time");
                break;
            }
            case "password": {
                schema.put("type", "string");
                schema.put("format", "password");
                break;
            }
            case "file": {
                schema.put("type", "string");
                schema.put("format", "uri");
                break;
            }
            case "geoPoint": {
                JsonSchemaTypeMapper.mapGeoTypeToSchema(schema);
                break;
            }
            default: {
                schema.put("type", "string");
            }
        }
    }

    private static void mapStringTypeToSchema(StringType stringType, ObjectNode schema) {
        Map expands = stringType.getExpands();
        if (expands != null) {
            if (expands.containsKey("minLength")) {
                schema.put("minLength", (Integer)expands.get("minLength"));
            }
            if (expands.containsKey("maxLength")) {
                schema.put("maxLength", (Integer)expands.get("maxLength"));
            }
            if (expands.containsKey("pattern")) {
                schema.put("pattern", (String)expands.get("pattern"));
            }
            if (expands.containsKey("format")) {
                schema.put("format", (String)expands.get("format"));
            }
        }
    }

    private static void mapNumberTypeToSchema(DataType dataType, ObjectNode schema) {
        if (dataType instanceof NumberType) {
            NumberType numberType = (NumberType)dataType;
            if (numberType.getMax() != null) {
                schema.put("maximum", numberType.getMax().doubleValue());
            }
            if (numberType.getMin() != null) {
                schema.put("minimum", numberType.getMin().doubleValue());
            }
        }
    }

    private static void mapObjectTypeToSchema(ObjectType objectType, ObjectNode schema) {
        ObjectNode properties = OBJECT_MAPPER.createObjectNode();
        ArrayNode required = OBJECT_MAPPER.createArrayNode();
        List propertyList = objectType.getProperties();
        if (propertyList != null) {
            for (PropertyMetadata property : propertyList) {
                JsonNode propertySchema = JsonSchemaTypeMapper.mapFromProperty(property);
                properties.set(property.getId(), propertySchema);
            }
        }
        schema.set("properties", (JsonNode)properties);
        if (required.size() > 0) {
            schema.set("required", (JsonNode)required);
        }
    }

    private static void mapArrayTypeToSchema(ArrayType arrayType, ObjectNode schema) {
        Map expands;
        DataType elementType = arrayType.getElementType();
        if (elementType != null) {
            SimplePropertyMetadata elementMetadata = new SimplePropertyMetadata();
            elementMetadata.setValueType(elementType);
            JsonNode itemsSchema = JsonSchemaTypeMapper.mapFromProperty((PropertyMetadata)elementMetadata);
            schema.set("items", itemsSchema);
        }
        if ((expands = arrayType.getExpands()) != null) {
            if (expands.containsKey("minItems")) {
                schema.put("minItems", (Integer)expands.get("minItems"));
            }
            if (expands.containsKey("maxItems")) {
                schema.put("maxItems", (Integer)expands.get("maxItems"));
            }
        }
    }

    private static void mapEnumTypeToSchema(EnumType enumType, ObjectNode schema) {
        schema.put("type", "string");
        ArrayNode enumArray = OBJECT_MAPPER.createArrayNode();
        List elements = enumType.getElements();
        if (elements != null) {
            for (EnumType.Element element : elements) {
                enumArray.add(element.getValue().toString());
            }
        }
        if (enumArray.size() > 0) {
            schema.set("enum", (JsonNode)enumArray);
        }
    }

    private static void mapGeoTypeToSchema(ObjectNode schema) {
        schema.put("type", "object");
        ObjectNode properties = OBJECT_MAPPER.createObjectNode();
        ObjectNode typeProperty = OBJECT_MAPPER.createObjectNode();
        typeProperty.put("type", "string");
        ArrayNode enumArray = OBJECT_MAPPER.createArrayNode();
        enumArray.add("Point");
        typeProperty.set("enum", (JsonNode)enumArray);
        properties.set("type", (JsonNode)typeProperty);
        ObjectNode coordinatesProperty = OBJECT_MAPPER.createObjectNode();
        coordinatesProperty.put("type", "array");
        coordinatesProperty.put("minItems", 2);
        coordinatesProperty.put("maxItems", 2);
        ObjectNode numberSchema = OBJECT_MAPPER.createObjectNode();
        numberSchema.put("type", "number");
        coordinatesProperty.set("items", (JsonNode)numberSchema);
        properties.set("coordinates", (JsonNode)coordinatesProperty);
        schema.set("properties", (JsonNode)properties);
        ArrayNode required = OBJECT_MAPPER.createArrayNode();
        required.add("type");
        required.add("coordinates");
        schema.set("required", (JsonNode)required);
    }

    private static void mapExpandsToSchema(Map<String, Object> expands, ObjectNode schema) {
        if (expands.containsKey("default")) {
            schema.putPOJO("default", expands.get("default"));
        }
        if (expands.containsKey("examples")) {
            schema.putPOJO("examples", expands.get("examples"));
        }
        if (expands.containsKey("const")) {
            schema.putPOJO("const", expands.get("const"));
        }
        for (Map.Entry<String, Object> entry : expands.entrySet()) {
            String key = entry.getKey();
            if (JsonSchemaTypeMapper.isStandardJsonSchemaProperty(key)) continue;
            schema.putPOJO("x-" + key, entry.getValue());
        }
    }

    private static boolean isStandardJsonSchemaProperty(String key) {
        return switch (key) {
            case "type", "properties", "items", "required", "enum", "const", "default", "examples", "title", "description", "minimum", "maximum", "multipleOf", "minLength", "maxLength", "pattern", "format", "minItems", "maxItems" -> true;
            default -> false;
        };
    }
}

