/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.UnknownType;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;
import org.jetlinks.supports.official.JetLinksPropertyMetadata;

public class JetLinksDeviceFunctionMetadata
implements FunctionMetadata {
    private transient JSONObject jsonObject;
    private transient FunctionMetadata another;
    private List<PropertyMetadata> inputs;
    private DataType output;
    private String id;
    private String name;
    private String description;
    private boolean async;
    private Map<String, Object> expands;

    public JetLinksDeviceFunctionMetadata() {
    }

    public JetLinksDeviceFunctionMetadata(String id, String name, List<PropertyMetadata> inputs, DataType output) {
        Objects.requireNonNull(id, "id cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(inputs, "inputs cannot be null");
        this.id = id;
        this.name = name;
        this.inputs = inputs;
        this.output = output;
    }

    public JetLinksDeviceFunctionMetadata(JSONObject jsonObject) {
        this.fromJson(jsonObject);
    }

    public JetLinksDeviceFunctionMetadata(FunctionMetadata another) {
        this.id = another.getId();
        this.name = another.getName();
        this.description = another.getDescription();
        this.expands = another.getExpands() == null ? null : new HashMap(another.getExpands());
        this.another = another;
        this.async = another.isAsync();
    }

    public List<PropertyMetadata> getInputs() {
        JSONArray arr;
        if (this.inputs == null && this.jsonObject != null && (arr = this.jsonObject.getJSONArray("inputs")) != null) {
            this.inputs = new ArrayList<PropertyMetadata>(arr.size());
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                JSONObject object = arr.getJSONObject(i);
                this.inputs.add(new JetLinksPropertyMetadata(object));
            }
        }
        if (this.inputs == null && this.another != null) {
            this.inputs = this.another.getInputs().stream().map(JetLinksPropertyMetadata::new).collect(Collectors.toList());
        }
        if (this.inputs == null) {
            return Collections.emptyList();
        }
        return this.inputs;
    }

    public DataType getOutput() {
        if (this.output == null && this.jsonObject != null) {
            this.output = Optional.ofNullable(this.jsonObject.getJSONObject("output")).flatMap(conf -> Optional.ofNullable(DataTypes.lookup((String)String.valueOf(conf.getOrDefault((Object)"type", (Object)"id")))).map(Supplier::get).map(type -> JetLinksDataTypeCodecs.decode(type, (Map<String, Object>)conf))).orElseGet(UnknownType::new);
        }
        if (this.output == null && this.another != null) {
            this.output = this.another.getOutput();
        }
        return this.output;
    }

    public String toString() {
        return String.join((CharSequence)"", "/* ", this.getName(), " */ ", this.output == null ? "void" : this.output.toString(), " ", this.getId(), "(", String.join((CharSequence)",", (CharSequence[])this.getInputs().stream().map(Object::toString).toArray(String[]::new)), ")");
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        json.put("description", (Object)this.description);
        json.put("async", (Object)this.async);
        json.put("inputs", this.getInputs().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        JetLinksDataTypeCodecs.encode(this.getOutput()).ifPresent(ot -> json.put("output", ot));
        json.put("expands", this.expands);
        return json;
    }

    public void fromJson(JSONObject json) {
        this.jsonObject = json;
        this.inputs = null;
        this.output = null;
        this.id = json.getString("id");
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.async = json.getBooleanValue("async");
        this.expands = json.getJSONObject("expands");
    }

    public FunctionMetadata merge(FunctionMetadata another, MergeOption ... option) {
        JetLinksDeviceFunctionMetadata function = new JetLinksDeviceFunctionMetadata(this);
        if (function.expands == null) {
            function.expands = new HashMap<String, Object>();
        }
        MergeOption.ExpandsMerge.doWith((DeviceMetadataType)DeviceMetadataType.function, (Map)another.getExpands(), function.expands, (MergeOption[])option);
        LinkedHashMap<String, PropertyMetadata> inputs = new LinkedHashMap<String, PropertyMetadata>();
        if (CollectionUtils.isNotEmpty(function.getInputs())) {
            for (PropertyMetadata input : function.getInputs()) {
                inputs.put(input.getId(), input);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)another.getInputs())) {
            for (PropertyMetadata input : another.getInputs()) {
                inputs.compute(input.getId(), (k, v) -> {
                    if (v == null) {
                        return input;
                    }
                    if (MergeOption.has((MergeOption)MergeOption.ignoreExists, (MergeOption[])option)) {
                        return v;
                    }
                    return v.merge(input, option);
                });
            }
        }
        function.inputs = new ArrayList(inputs.values());
        return function;
    }

    @Generated
    public void setInputs(List<PropertyMetadata> inputs) {
        this.inputs = inputs;
    }

    @Generated
    public void setOutput(DataType output) {
        this.output = output;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Generated
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Generated
    public Map<String, Object> getExpands() {
        return this.expands;
    }

    @Generated
    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

