/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.UnknownType;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;

public class JetLinksEventMetadata
implements EventMetadata {
    private JSONObject jsonObject;
    private DataType type;
    private transient EventMetadata another;
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;

    public JetLinksEventMetadata(String id, String name, DataType type) {
        Objects.requireNonNull(id, "id cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.id = id;
        this.name = name;
        this.type = type;
    }

    public JetLinksEventMetadata(JSONObject jsonObject) {
        this.fromJson(jsonObject);
    }

    public JetLinksEventMetadata(EventMetadata another) {
        this.another = another;
        this.id = another.getId();
        this.name = another.getName();
        this.description = another.getDescription();
        this.expands = another.getExpands();
    }

    public DataType getType() {
        if (this.type == null && this.jsonObject != null) {
            JSONObject typeJson = this.jsonObject.getJSONObject("valueType");
            this.type = Optional.ofNullable(typeJson.getString("type")).map(DataTypes::lookup).map(Supplier::get).orElseGet(UnknownType::new);
            this.type = JetLinksDataTypeCodecs.decode(this.type, (Map<String, Object>)typeJson);
        }
        if (this.type == null && this.another != null) {
            this.type = this.another.getType();
        }
        return this.type;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)this.id);
        jsonObject.put("name", (Object)this.name);
        jsonObject.put("description", (Object)this.description);
        jsonObject.put("valueType", JetLinksDataTypeCodecs.encode(this.getType()).orElse(null));
        jsonObject.put("expands", this.expands);
        return jsonObject;
    }

    public void fromJson(JSONObject json) {
        this.jsonObject = json;
        this.type = null;
        this.id = json.getString("id");
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.expands = json.getJSONObject("expands");
    }

    public EventMetadata merge(EventMetadata another, MergeOption ... option) {
        JetLinksEventMetadata metadata = new JetLinksEventMetadata(this);
        if (metadata.expands == null) {
            metadata.expands = new HashMap<String, Object>();
        }
        MergeOption.ExpandsMerge.doWith((DeviceMetadataType)DeviceMetadataType.event, (Map)another.getExpands(), metadata.expands, (MergeOption[])option);
        return metadata;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Map<String, Object> getExpands() {
        return this.expands;
    }

    @Generated
    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

