/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.message.property.ReportPropertyMessage;
import org.jetlinks.supports.protocol.codec.BinaryDecoder;
import org.jetlinks.supports.protocol.codec.BlockingDecoder;
import org.jetlinks.supports.protocol.codec.BlockingDecoderBuilder;
import org.jetlinks.supports.protocol.codec.CodecPredicate;

class DefaultBlockingDecoderBuilder
implements BlockingDecoderBuilder {
    private final Set<BlockingDecoderStatement<?>> statements = new HashSet();

    DefaultBlockingDecoderBuilder() {
    }

    @Override
    public BlockingDecoderBuilder.BlockingDecoderDeclaration declare() {
        return new DefaultBlockingDecoderDeclaration();
    }

    @Override
    public BlockingDecoder build() {
        return new DefaultBlockingDecoder();
    }

    private class DefaultBlockingDecoderDeclaration
    implements BlockingDecoderStatement<CommonDeviceMessage>,
    BlockingDecoderBuilder.BlockingDecoderDeclaration {
        CodecPredicate predicate;
        BinaryDecoder<String> deviceIdDecoder;
        BinaryDecoder<Long> timestampDecoder;
        BiFunction<byte[], Integer, ? extends CommonDeviceMessage> messageSupplier;

        private DefaultBlockingDecoderDeclaration() {
        }

        @Override
        public boolean test(byte[] message, int offset) {
            return this.predicate == null || this.predicate.test(message, offset);
        }

        @Override
        public CommonDeviceMessage decode(byte[] message, int offset) {
            CommonDeviceMessage deviceMessage = this.messageSupplier.apply(message, offset);
            if (this.timestampDecoder != null) {
                deviceMessage.setTimestamp(this.timestampDecoder.decode(message, offset).longValue());
            }
            if (this.deviceIdDecoder != null) {
                deviceMessage.setDeviceId(this.deviceIdDecoder.decode(message, offset));
            }
            return deviceMessage;
        }

        @Override
        public BlockingDecoderBuilder.BlockingDecoderDeclaration match(CodecPredicate predicate) {
            this.predicate = this.predicate == null ? predicate : this.predicate.and(predicate);
            return this;
        }

        @Override
        public BlockingDecoderBuilder.BlockingDecoderDeclaration deviceId(BinaryDecoder<String> part) {
            this.deviceIdDecoder = part;
            return this;
        }

        @Override
        public BlockingDecoderBuilder.BlockingDecoderDeclaration timestamp(BinaryDecoder<Long> decoder) {
            this.timestampDecoder = decoder;
            return this;
        }

        @Override
        public BlockingDecoderBuilder.PropertyMessageDecoderDeclaration isReportProperty() {
            this.messageSupplier = new ReportPropertyBinaryMessageDecoderDeclaration(this);
            return this.messageSupplier;
        }

        @Override
        public BlockingDecoderBuilder.EventMessageDecoderDeclaration isEvent() {
            this.messageSupplier = new EventBinaryMessageDecoderDeclaration(this);
            return this.messageSupplier;
        }

        public BlockingDecoderBuilder.BlockingDecoderDeclaration next() {
            DefaultBlockingDecoderBuilder.this.statements.add(this);
            return new DefaultBlockingDecoderDeclaration();
        }

        @Override
        public BlockingDecoderBuilder end() {
            DefaultBlockingDecoderBuilder.this.statements.add(this);
            return DefaultBlockingDecoderBuilder.this;
        }
    }

    private class DefaultBlockingDecoder
    implements BlockingDecoder {
        @Override
        public DeviceMessage decode(byte[] message, int offset) {
            for (BlockingDecoderStatement<?> statement : DefaultBlockingDecoderBuilder.this.statements) {
                if (!statement.test(message, offset)) continue;
                return statement.decode(message, offset);
            }
            return null;
        }

        @Generated
        public DefaultBlockingDecoder() {
        }
    }

    private static class EventBinaryMessageDecoderDeclaration
    implements BlockingDecoderBuilder.EventMessageDecoderDeclaration,
    BiFunction<byte[], Integer, EventMessage> {
        private BinaryDecoder<?> decoder;
        private BinaryDecoder<String> eventIdDecoder;
        private final DefaultBlockingDecoderDeclaration creator;

        public EventBinaryMessageDecoderDeclaration(DefaultBlockingDecoderDeclaration creator) {
            this.creator = creator;
        }

        @Override
        public EventMessage apply(byte[] message, Integer offset) {
            EventMessage msg = new EventMessage();
            msg.setEvent(this.eventIdDecoder.decode(message, offset));
            msg.setData(this.decoder.decode(message, offset));
            return msg;
        }

        @Override
        public BlockingDecoderBuilder.BlockingDecoderDeclaration next() {
            this.check();
            return this.creator.next();
        }

        @Override
        public BlockingDecoderBuilder.EventMessageDecoderDeclaration eventId(BinaryDecoder<String> decoder) {
            this.eventIdDecoder = decoder;
            return this;
        }

        @Override
        public BlockingDecoderBuilder.EventMessageDecoderDeclaration data(BinaryDecoder<?> decoder) {
            this.decoder = decoder;
            return this;
        }

        @Override
        public BlockingDecoderBuilder end() {
            this.check();
            return this.creator.end();
        }

        private void check() {
            Objects.requireNonNull(this.decoder, "please call data(..) method before");
            Objects.requireNonNull(this.eventIdDecoder, "please call eventId(..) method before");
        }
    }

    private static class ReportPropertyBinaryMessageDecoderDeclaration
    implements BlockingDecoderBuilder.PropertyMessageDecoderDeclaration,
    BiFunction<byte[], Integer, ReportPropertyMessage> {
        private BinaryDecoder<Map<String, Object>> decoder;
        private final DefaultBlockingDecoderDeclaration creator;
        private BinaryDecoder<?> messageIdDecoder;

        public ReportPropertyBinaryMessageDecoderDeclaration(DefaultBlockingDecoderDeclaration creator) {
            this.creator = creator;
        }

        @Override
        public ReportPropertyMessage apply(byte[] message, Integer offset) {
            ReportPropertyMessage msg = new ReportPropertyMessage();
            if (this.messageIdDecoder != null) {
                msg.setMessageId(String.valueOf(this.messageIdDecoder.decode(message, offset)));
            }
            msg.setProperties(this.decoder.decode(message, offset));
            return msg;
        }

        @Override
        public BlockingDecoderBuilder.PropertyMessageDecoderDeclaration properties(BinaryDecoder<Map<String, Object>> decoder) {
            this.decoder = decoder;
            return this;
        }

        @Override
        public BlockingDecoderBuilder.PropertyMessageDecoderDeclaration messageId(BinaryDecoder<?> decoder) {
            this.messageIdDecoder = decoder;
            return this;
        }

        @Override
        public BlockingDecoderBuilder.BlockingDecoderDeclaration next() {
            Objects.requireNonNull(this.decoder, "please call properties(..) method before");
            return this.creator.next();
        }

        @Override
        public BlockingDecoderBuilder end() {
            Objects.requireNonNull(this.decoder, "please call properties(..) method before");
            return this.creator.end();
        }
    }

    private static interface BlockingDecoderStatement<M extends DeviceMessage>
    extends BlockingDecoder {
        public boolean test(byte[] var1, int var2);

        public M decode(byte[] var1, int var2);
    }
}

